/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.bdio2.util;

import com.blackduck.integration.bdio.graph.DependencyGraph;
import com.blackduck.integration.bdio.graph.ProjectDependencyGraph;
import com.blackduck.integration.bdio.model.dependency.Dependency;
import com.blackduck.integration.bdio.model.dependency.ProjectDependency;
import com.blackduck.integration.bdio.model.externalid.ExternalId;
import com.blackduck.integration.blackduck.bdio2.model.Bdio2Document;
import com.blackduck.integration.blackduck.bdio2.model.ProjectInfo;
import com.blackduck.integration.util.NameVersion;
import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.BdioObject;
import com.blackducksoftware.bdio2.LegacyUtilities;
import com.blackducksoftware.bdio2.model.Component;
import com.blackducksoftware.bdio2.model.Project;
import com.blackducksoftware.common.value.Product;
import com.blackducksoftware.common.value.ProductList;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bdio2Factory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final List<Product> DEFAULT_PRODUCTS = Arrays.asList(Product.java(), Product.os());

    public Bdio2Document createBdio2Document(BdioMetadata bdioMetadata, ProjectDependencyGraph dependencyGraph) {
        Project project = this.createProject(dependencyGraph.getProjectDependency().getExternalId(), true);
        Pair<List<Project>, List<Component>> subprojectsAndComponents = this.createAndLinkComponents((DependencyGraph)dependencyGraph, project);
        return new Bdio2Document(bdioMetadata, project, (List)subprojectsAndComponents.getLeft(), (List)subprojectsAndComponents.getRight());
    }

    @Deprecated
    public Bdio2Document createLegacyBdio2Document(BdioMetadata bdioMetadata, DependencyGraph dependencyGraph, ProjectInfo projectInfo, ExternalId projectExternalId) {
        Project project = this.createProject(projectInfo.getNameVersion(), projectExternalId, true);
        Pair<List<Project>, List<Component>> subprojectsAndComponents = this.createAndLinkComponents(dependencyGraph, project);
        return new Bdio2Document(bdioMetadata, project, (List)subprojectsAndComponents.getLeft(), (List)subprojectsAndComponents.getRight());
    }

    public BdioMetadata createBdioMetadata(String codeLocationName, ProjectInfo projectInfo, ZonedDateTime creationDateTime) {
        return this.createBdioMetadata(codeLocationName, projectInfo, creationDateTime, DEFAULT_PRODUCTS);
    }

    public BdioMetadata createBdioMetadata(String codeLocationName, ProjectInfo projectInfo, ZonedDateTime creationDateTime, Product product) {
        return this.createBdioMetadata(codeLocationName, projectInfo, creationDateTime, this.addLists(DEFAULT_PRODUCTS, Collections.singletonList(product)));
    }

    public BdioMetadata createBdioMetadata(String codeLocationName, ProjectInfo projectInfo, ZonedDateTime creationDateTime, List<Product> products) {
        ProductList productList = (ProductList)this.addLists(DEFAULT_PRODUCTS, products).stream().collect(ProductList.toProductList());
        return this.createBdioMetadata(codeLocationName, projectInfo, creationDateTime, productList);
    }

    @Deprecated
    protected Project createProject(NameVersion projectNameVersion, ExternalId identifier, boolean isRootProject) {
        Project project = new Project(identifier.createBdioId().toString()).identifier(identifier.createExternalId()).name(projectNameVersion.getName()).version(projectNameVersion.getVersion());
        if (isRootProject) {
            project.namespace("root");
        }
        return project;
    }

    protected Project createProject(ExternalId projectExternalId, boolean isRootProject) {
        Project project = new Project(projectExternalId.createBdioId().toString()).identifier(projectExternalId.createExternalId()).name(projectExternalId.getName()).version(projectExternalId.getVersion());
        if (isRootProject) {
            project.namespace("root");
        }
        return project;
    }

    protected Pair<List<Project>, List<Component>> createAndLinkComponents(DependencyGraph dependencyGraph, Project project) {
        return this.createAndLinkComponentsFromGraph(dependencyGraph, arg_0 -> ((Project)project).subproject(arg_0), arg_0 -> ((Project)project).dependency(arg_0), dependencyGraph.getDirectDependencies(), new HashMap<ExternalId, Project>(), new HashMap<ExternalId, Component>());
    }

    private BdioMetadata createBdioMetadata(String codeLocationName, ProjectInfo projectInfo, ZonedDateTime creationDateTime, ProductList productList) {
        BdioMetadata metadata = new BdioMetadata().id(LegacyUtilities.toNameUri((String)codeLocationName)).name(codeLocationName).project(projectInfo.getNameVersion().getName()).projectVersion(projectInfo.getNameVersion().getVersion()).creationDateTime(creationDateTime).publisher(productList);
        projectInfo.getProjectGroup().ifPresent(arg_0 -> ((BdioMetadata)metadata).projectGroup(arg_0));
        projectInfo.getCorrelationId().ifPresent(arg_0 -> ((BdioMetadata)metadata).correlationId(arg_0));
        projectInfo.getGitInfo().getSourceRevision().ifPresent(arg_0 -> ((BdioMetadata)metadata).sourceRevision(arg_0));
        projectInfo.getGitInfo().getSourceBranch().ifPresent(arg_0 -> ((BdioMetadata)metadata).sourceBranch(arg_0));
        projectInfo.getGitInfo().getSourceRepository().ifPresent(arg_0 -> ((BdioMetadata)metadata).sourceRepository(arg_0));
        return metadata;
    }

    private Pair<List<Project>, List<Component>> createAndLinkComponentsFromGraph(DependencyGraph dependencyGraph, @Nullable SubProjectFunction linkProjectDependency, DependencyFunction linkComponentDependency, Set<Dependency> dependencies, Map<ExternalId, Project> existingSubprojects, Map<ExternalId, Component> existingComponents) {
        ArrayList<Project> addedSubprojects = new ArrayList<Project>();
        ArrayList<Component> addedComponents = new ArrayList<Component>();
        for (Dependency dependency : dependencies) {
            Pair<List<Project>, List<Component>> children;
            if (dependency instanceof ProjectDependency) {
                if (linkProjectDependency == null) {
                    String subprojectExternalId = dependency.getExternalId().toString();
                    this.logger.warn("Sipping subproject {}. Failed to add the subproject to the graph because subprojects cannot be dependencies of components. Please contact Black Duck support.", (Object)subprojectExternalId);
                    continue;
                }
                Project subproject = this.projectFromDependency(dependency);
                linkProjectDependency.subProject(new Project(subproject.id()).subproject(subproject));
                if (existingSubprojects.containsKey(dependency.getExternalId())) continue;
                addedSubprojects.add(subproject);
                existingSubprojects.put(dependency.getExternalId(), subproject);
                children = this.createAndLinkComponentsFromGraph(dependencyGraph, arg_0 -> ((Project)subproject).subproject(arg_0), arg_0 -> ((Project)subproject).dependency(arg_0), dependencyGraph.getChildrenForParent(dependency), existingSubprojects, existingComponents);
                addedSubprojects.addAll((Collection)children.getLeft());
                addedComponents.addAll((Collection)children.getRight());
                continue;
            }
            Component component = this.componentFromDependency(dependency);
            linkComponentDependency.dependency(new com.blackducksoftware.bdio2.model.Dependency().dependsOn((Object)component));
            if (existingComponents.containsKey(dependency.getExternalId())) continue;
            addedComponents.add(component);
            existingComponents.put(dependency.getExternalId(), component);
            children = this.createAndLinkComponentsFromGraph(dependencyGraph, null, arg_0 -> ((Component)component).dependency(arg_0), dependencyGraph.getChildrenForParent(dependency), existingSubprojects, existingComponents);
            addedSubprojects.addAll((Collection)children.getLeft());
            addedComponents.addAll((Collection)children.getRight());
        }
        return Pair.of(addedSubprojects, addedComponents);
    }

    private Project projectFromDependency(Dependency dependency) {
        return new Project(dependency.getExternalId().createBdioId().toString()).name(dependency.getName()).version(dependency.getVersion()).identifier(dependency.getExternalId().createExternalId()).namespace(dependency.getExternalId().getForge().getName());
    }

    private Component componentFromDependency(Dependency dependency) {
        return new Component(dependency.getExternalId().createBdioId().toString()).name(dependency.getName()).version(dependency.getVersion()).identifier(dependency.getExternalId().createExternalId()).namespace(dependency.getExternalId().getForge().getName());
    }

    private List<Product> addLists(List<Product> list1, List<Product> list2) {
        return Stream.concat(list1.stream(), list2.stream()).distinct().collect(Collectors.toList());
    }

    @FunctionalInterface
    private static interface SubProjectFunction {
        public BdioObject subProject(@Nullable Project var1);
    }

    @FunctionalInterface
    private static interface DependencyFunction {
        public BdioObject dependency(@Nullable com.blackducksoftware.bdio2.model.Dependency var1);
    }
}

