/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.bdio2.model;

import com.blackduck.integration.bdio.model.dependency.ProjectDependency;
import com.blackduck.integration.blackduck.bdio2.model.GitInfo;
import com.blackduck.integration.util.NameVersion;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ProjectInfo {
    private final NameVersion nameVersion;
    @Nullable
    private final String projectGroup;
    @Nullable
    private final String correlationId;
    private final GitInfo gitInfo;

    public static ProjectInfo fromProjectDependency(ProjectDependency projectDependency) {
        String projectName = projectDependency.getExternalId().getName();
        String projectVersion = projectDependency.getExternalId().getVersion();
        String projectGroup = StringUtils.trimToNull((String)projectDependency.getExternalId().getGroup());
        return ProjectInfo.nameVersionGroup(new NameVersion(projectName, projectVersion), projectGroup);
    }

    public static ProjectInfo nameVersion(NameVersion nameVersion) {
        return ProjectInfo.nameVersionGit(nameVersion, GitInfo.none());
    }

    public static ProjectInfo nameVersionGroup(NameVersion nameVersion, String group) {
        return ProjectInfo.nameVersionGroupGit(nameVersion, group, GitInfo.none());
    }

    public static ProjectInfo nameVersionGit(NameVersion nameVersion, GitInfo gitInfo) {
        return ProjectInfo.nameVersionGroupGit(nameVersion, null, gitInfo);
    }

    public static ProjectInfo nameVersionGroupGit(NameVersion nameVersion, String group, GitInfo gitInfo) {
        return new ProjectInfo(nameVersion, group, null, gitInfo);
    }

    public ProjectInfo(NameVersion nameVersion, @Nullable String projectGroup, @Nullable String correlationId, GitInfo gitInfo) {
        this.nameVersion = nameVersion;
        this.projectGroup = projectGroup;
        this.correlationId = correlationId;
        this.gitInfo = gitInfo;
    }

    public NameVersion getNameVersion() {
        return this.nameVersion;
    }

    public Optional<String> getProjectGroup() {
        return Optional.ofNullable(this.projectGroup);
    }

    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(this.correlationId);
    }

    public GitInfo getGitInfo() {
        return this.gitInfo;
    }
}

