/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.bdio2;

import com.blackduck.integration.blackduck.bdio2.Bdio2RetryAwareStreamUploader;
import com.blackduck.integration.blackduck.bdio2.Bdio2UploadResult;
import com.blackduck.integration.blackduck.bdio2.RetriableBdioUploadException;
import com.blackduck.integration.blackduck.bdio2.model.BdioFileContent;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequestBuilderEditor;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.exception.IntegrationTimeoutException;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.wait.ResilientJob;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bdio2UploadJob
implements ResilientJob<Bdio2UploadResult> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String UPLOAD_JOB_NAME = "bdio upload";
    private static final String INTELLIGENT_PERSISTANCE_API_ENDPOINT = "api/intelligent-persistence-scans/";
    private final Bdio2RetryAwareStreamUploader bdio2RetryAwareStreamUploader;
    private final BdioFileContent header;
    private final List<BdioFileContent> bdioEntries;
    private final BlackDuckRequestBuilderEditor editor;
    private final int count;
    private final boolean shouldUploadEntries;
    private final boolean shouldFinishUpload;
    private HttpUrl uploadUrl;
    private String scanId;
    private boolean complete;
    private HttpUrl blackDuckUrl;
    private long startTime;
    private long timeout;

    public Bdio2UploadJob(Bdio2RetryAwareStreamUploader bdio2RetryAwareStreamUploader, BdioFileContent header, List<BdioFileContent> bdioEntries, BlackDuckRequestBuilderEditor editor, int count, boolean onlyUploadHeader, boolean shouldFinishUpload, long startTime, long timeout, String scanId, HttpUrl blackDuckUrl) {
        this.bdio2RetryAwareStreamUploader = bdio2RetryAwareStreamUploader;
        this.header = header;
        this.bdioEntries = bdioEntries;
        this.editor = editor;
        this.count = count;
        this.shouldUploadEntries = onlyUploadHeader;
        this.shouldFinishUpload = shouldFinishUpload;
        this.startTime = startTime;
        this.timeout = timeout;
        this.scanId = scanId;
        this.blackDuckUrl = blackDuckUrl;
    }

    public void attemptJob() throws IntegrationException {
        try {
            if (this.isOldNonSCASSWorkflow()) {
                Response headerResponse = this.bdio2RetryAwareStreamUploader.start(this.header, this.editor, this.startTime, this.timeout);
                this.bdio2RetryAwareStreamUploader.onErrorThrowRetryableOrFailure(headerResponse);
                this.uploadUrl = new HttpUrl(headerResponse.getHeaderValue("location"));
                this.scanId = this.parseScanIdFromUploadUrl(this.uploadUrl.string());
            } else {
                if (!this.blackDuckUrl.string().endsWith("/")) {
                    this.blackDuckUrl = new HttpUrl(this.blackDuckUrl + "/");
                }
                this.uploadUrl = new HttpUrl(this.blackDuckUrl + INTELLIGENT_PERSISTANCE_API_ENDPOINT + this.scanId);
            }
            this.complete = true;
            if (this.shouldUploadEntries) {
                this.logger.debug(String.format("Starting upload to %s", this.uploadUrl.string()));
                for (BdioFileContent content : this.bdioEntries) {
                    Response chunkResponse = this.bdio2RetryAwareStreamUploader.append(this.uploadUrl, this.count, content, this.editor);
                    this.bdio2RetryAwareStreamUploader.onErrorThrowRetryableOrFailure(chunkResponse);
                }
            }
            if (this.shouldFinishUpload) {
                Response finishResponse = this.bdio2RetryAwareStreamUploader.finish(this.uploadUrl, this.count, this.editor);
                this.bdio2RetryAwareStreamUploader.onErrorThrowRetryableOrFailure(finishResponse);
            }
        }
        catch (RetriableBdioUploadException | InterruptedException e) {
            this.complete = false;
        }
    }

    private String parseScanIdFromUploadUrl(String uploadUrl) {
        String[] pieces = uploadUrl.split("/");
        return pieces[pieces.length - 1];
    }

    private boolean isOldNonSCASSWorkflow() {
        return this.scanId == null || this.scanId.isEmpty() || this.blackDuckUrl == null || this.blackDuckUrl.toString().isEmpty();
    }

    public boolean wasJobCompleted() {
        return this.complete;
    }

    public Bdio2UploadResult onTimeout() throws IntegrationTimeoutException {
        throw new IntegrationTimeoutException("Not able to upload BDIO due to timeout.");
    }

    public Bdio2UploadResult onCompletion() {
        return new Bdio2UploadResult(this.uploadUrl, this.scanId);
    }

    public String getName() {
        return UPLOAD_JOB_NAME;
    }
}

