/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.bdio2;

import com.blackduck.integration.blackduck.bdio2.Bdio2StreamUploader;
import com.blackduck.integration.blackduck.bdio2.RetriableBdioUploadException;
import com.blackduck.integration.blackduck.bdio2.model.BdioFileContent;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequestBuilderEditor;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.exception.IntegrationRestException;
import com.blackduck.integration.rest.response.Response;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bdio2RetryAwareStreamUploader {
    private static final List<Integer> NON_RETRYABLE_EXIT_CODES = Arrays.asList(401, 402, 403, 404, 409, 412);
    private static final Integer TOO_MANY_REQUESTS_CODE = 429;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Bdio2StreamUploader bdio2StreamUploader;

    public Bdio2RetryAwareStreamUploader(Bdio2StreamUploader bdio2StreamUploader) {
        this.bdio2StreamUploader = bdio2StreamUploader;
    }

    public Response start(BdioFileContent header, BlackDuckRequestBuilderEditor editor, long clientStartTime, long clientTimeout) throws RetriableBdioUploadException, IntegrationException, InterruptedException {
        this.logger.trace("Executing BDIO upload start operation; non-retryable status codes: {}", NON_RETRYABLE_EXIT_CODES);
        try {
            Response response = this.bdio2StreamUploader.start(header, editor);
            if (!response.isStatusCodeSuccess() && this.isRetryableExitCode(response.getStatusCode())) {
                String retryAfterInSeconds = response.getHeaderValue("retry-after");
                if (null != retryAfterInSeconds && !retryAfterInSeconds.equals("0")) {
                    long retryAfterInMillis = Integer.parseInt(retryAfterInSeconds) * 1000;
                    if (this.isClientTimeoutExceededBy(clientStartTime, retryAfterInMillis, clientTimeout)) {
                        throw new BlackDuckIntegrationException("Client timeout exceeded or will be exceeded due to server being busy.");
                    }
                    this.logger.debug("Received code {}. Waiting {} milliseconds to retry BDIO upload start operation.", (Object)response.getStatusCode(), (Object)retryAfterInMillis);
                    Thread.sleep(retryAfterInMillis);
                    return this.start(header, editor, clientStartTime, clientTimeout);
                }
                if (response.getStatusCode() == TOO_MANY_REQUESTS_CODE.intValue()) {
                    throw new BlackDuckIntegrationException("The server is busy and did not specify retrying the request or provide a retry period.");
                }
            }
            return response;
        }
        catch (IntegrationRestException e) {
            return this.translateRetryableExceptions(e);
        }
    }

    public Response append(HttpUrl uploadUrl, int count, BdioFileContent content, BlackDuckRequestBuilderEditor editor) throws RetriableBdioUploadException, IntegrationException {
        this.logger.trace("Executing BDIO upload append operation");
        Response response = null;
        try {
            response = this.bdio2StreamUploader.append(uploadUrl, count, content, editor);
        }
        catch (IntegrationRestException e) {
            this.translateRetryableExceptions(e);
        }
        return response;
    }

    public Response finish(HttpUrl uploadUrl, int count, BlackDuckRequestBuilderEditor editor) throws RetriableBdioUploadException, IntegrationException {
        this.logger.trace("Executing BDIO upload finish operation");
        Response response = null;
        try {
            response = this.bdio2StreamUploader.finish(uploadUrl, count, editor);
        }
        catch (IntegrationRestException e) {
            this.translateRetryableExceptions(e);
        }
        return response;
    }

    public void onErrorThrowRetryableOrFailure(Response response) throws IntegrationException, RetriableBdioUploadException {
        if (!response.isStatusCodeSuccess()) {
            if (this.isRetryableExitCode(response.getStatusCode())) {
                this.logger.trace("Response status code {} is retryable", (Object)response.getStatusCode());
                throw new RetriableBdioUploadException();
            }
            this.logger.trace("Response status code {} is not retryable", (Object)response.getStatusCode());
            throw new IntegrationException(String.format("Bdio upload failed with non-retryable exit code: %d", response.getStatusCode()));
        }
        this.logger.trace("Response status code {} treated as success", (Object)response.getStatusCode());
    }

    private boolean isClientTimeoutExceededBy(long startTime, long waitInMillis, long clientTimeout) {
        long currentTime = System.currentTimeMillis();
        return currentTime - startTime + waitInMillis > clientTimeout * 1000L;
    }

    private Response translateRetryableExceptions(IntegrationRestException e) throws RetriableBdioUploadException, IntegrationRestException {
        if (this.isRetryableExitCode(e.getHttpStatusCode())) {
            this.logger.trace("Response status code {} in caught exception is retryable", (Object)e.getHttpStatusCode());
            throw new RetriableBdioUploadException();
        }
        throw e;
    }

    private boolean isRetryableExitCode(int exitCode) {
        return !NON_RETRYABLE_EXIT_CODES.contains(exitCode);
    }
}

