/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.bdio2;

import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.bdio2.Bdio2RetryAwareStreamUploader;
import com.blackduck.integration.blackduck.bdio2.Bdio2UploadJob;
import com.blackduck.integration.blackduck.bdio2.Bdio2UploadResult;
import com.blackduck.integration.blackduck.bdio2.model.BdioFileContent;
import com.blackduck.integration.blackduck.bdio2.util.Bdio2ContentExtractor;
import com.blackduck.integration.blackduck.codelocation.upload.UploadTarget;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequestBuilderEditor;
import com.blackduck.integration.blackduck.version.BlackDuckVersion;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.util.NameVersion;
import com.blackduck.integration.wait.ResilientJob;
import com.blackduck.integration.wait.ResilientJobConfig;
import com.blackduck.integration.wait.ResilientJobExecutor;
import com.blackduck.integration.wait.tracker.WaitIntervalTracker;
import com.blackduck.integration.wait.tracker.WaitIntervalTrackerFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Bdio2FileUploadService
extends DataService {
    private static final String FILE_NAME_BDIO_HEADER_JSONLD = "bdio-header.jsonld";
    private static final int BD_WAIT_AND_RETRY_INTERVAL = 30;
    private final Bdio2ContentExtractor bdio2Extractor;
    private final Bdio2RetryAwareStreamUploader bdio2RetryAwareStreamUploader;

    public Bdio2FileUploadService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger, Bdio2ContentExtractor bdio2Extractor, Bdio2RetryAwareStreamUploader bdio2RetryAwareStreamUploader) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.bdio2Extractor = bdio2Extractor;
        this.bdio2RetryAwareStreamUploader = bdio2RetryAwareStreamUploader;
    }

    public Bdio2UploadResult uploadFile(UploadTarget uploadTarget, long timeout, long clientStartTime) throws IntegrationException, InterruptedException {
        return this.uploadFile(uploadTarget, timeout, true, true, clientStartTime);
    }

    public Bdio2UploadResult uploadFile(UploadTarget uploadTarget, long timeout, boolean shouldUploadEntries, boolean shouldFinishUpload, long clientStartTime) throws IntegrationException, InterruptedException {
        this.logger.debug(String.format("Uploading BDIO file %s", uploadTarget.getUploadFile()));
        List<BdioFileContent> bdioFileContentList = this.bdio2Extractor.extractContent(uploadTarget.getUploadFile());
        return this.uploadFiles(bdioFileContentList, uploadTarget.getProjectAndVersion().orElse(null), timeout, shouldUploadEntries, shouldFinishUpload, clientStartTime, uploadTarget.getScanId(), uploadTarget.getBlackDuckUrl());
    }

    private Bdio2UploadResult uploadFiles(List<BdioFileContent> bdioFiles, @Nullable NameVersion nameVersion, long timeout, boolean shouldUploadEntries, boolean shouldFinishUpload, long clientStartTime, @Nullable String scanId, @Nullable HttpUrl blackDuckUrl) throws IntegrationException, InterruptedException {
        if (bdioFiles.isEmpty()) {
            throw new IllegalArgumentException("BDIO files cannot be empty.");
        }
        BdioFileContent header = bdioFiles.stream().filter(content -> content.getFileName().equals(FILE_NAME_BDIO_HEADER_JSONLD)).findFirst().orElseThrow(() -> new BlackDuckIntegrationException("Cannot find BDIO header filebdio-header.jsonld."));
        List<BdioFileContent> remainingFiles = bdioFiles.stream().filter(content -> !content.getFileName().equals(FILE_NAME_BDIO_HEADER_JSONLD)).collect(Collectors.toList());
        int count = remainingFiles.size();
        this.logger.debug("BDIO upload file count = " + count);
        BlackDuckRequestBuilderEditor editor = noOp -> {};
        if (nameVersion != null && !this.useOnlyBdioHeaders()) {
            editor = builder -> builder.addHeader("X-BD-PROJECT-NAME", nameVersion.getName()).addHeader("X-BD-VERSION-NAME", nameVersion.getVersion());
        }
        WaitIntervalTracker waitIntervalTracker = WaitIntervalTrackerFactory.createConstant((long)timeout, (long)30L);
        ResilientJobConfig jobConfig = new ResilientJobConfig(this.logger, System.currentTimeMillis(), waitIntervalTracker);
        Bdio2UploadJob bdio2UploadJob = new Bdio2UploadJob(this.bdio2RetryAwareStreamUploader, header, remainingFiles, editor, count, shouldUploadEntries, shouldFinishUpload, clientStartTime, timeout, scanId, blackDuckUrl);
        ResilientJobExecutor jobExecutor = new ResilientJobExecutor(jobConfig);
        return (Bdio2UploadResult)jobExecutor.executeJob((ResilientJob)bdio2UploadJob);
    }

    private boolean useOnlyBdioHeaders() {
        if (this.blackDuckApiClient.getBlackDuckVersion().isPresent()) {
            BlackDuckVersion currentBlackDuckVersion = this.blackDuckApiClient.getBlackDuckVersion().get();
            BlackDuckVersion requiresBdioHeadersVersion = new BlackDuckVersion(2023, 4, 1);
            return currentBlackDuckVersion.isAtLeast(requiresBdioHeadersVersion);
        }
        return false;
    }
}

