/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.extensions.pipeline;

import com.blackduck.integration.jenkins.detect.extensions.DetectDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.InheritFromGlobalDownloadStrategy;
import com.blackduck.integration.jenkins.detect.service.DetectCommandsFactory;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DetectPipelineStep
extends Step
implements Serializable {
    public static final String DISPLAY_NAME = "Black Duck Detect";
    public static final String PIPELINE_NAME = "blackduck_detect";
    private static final long serialVersionUID = 8126672300843832671L;
    private final String detectProperties;
    private boolean returnStatus = false;
    @Nullable
    private DetectDownloadStrategy downloadStrategyOverride;

    @DataBoundConstructor
    public DetectPipelineStep(String detectProperties) {
        this.detectProperties = detectProperties;
    }

    public String getDetectProperties() {
        return this.detectProperties;
    }

    public DetectDownloadStrategy getDownloadStrategyOverride() {
        return this.downloadStrategyOverride;
    }

    @DataBoundSetter
    public void setDownloadStrategyOverride(DetectDownloadStrategy downloadStrategyOverride) {
        this.downloadStrategyOverride = downloadStrategyOverride;
    }

    public DetectDownloadStrategy getDefaultDownloadStrategyOverride() {
        return new InheritFromGlobalDownloadStrategy();
    }

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    @DataBoundSetter
    public void setReturnStatus(boolean returnStatus) {
        this.returnStatus = returnStatus;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context);
    }

    public class Execution
    extends SynchronousNonBlockingStepExecution<Integer> {
        private static final long serialVersionUID = -5807577350749324767L;
        private final transient TaskListener listener;
        private final transient EnvVars envVars;
        private final transient FilePath workspace;
        private final transient Launcher launcher;
        private final transient Node node;

        protected Execution(StepContext context) throws InterruptedException, IOException {
            super(context);
            this.listener = (TaskListener)context.get(TaskListener.class);
            this.envVars = (EnvVars)context.get(EnvVars.class);
            this.workspace = (FilePath)context.get(FilePath.class);
            this.launcher = (Launcher)context.get(Launcher.class);
            this.node = (Node)context.get(Node.class);
        }

        protected Integer run() throws Exception {
            return DetectCommandsFactory.fromPipeline(this.listener, this.envVars, this.launcher, this.node, this.workspace).runDetect(DetectPipelineStep.this.returnStatus, DetectPipelineStep.this.detectProperties, DetectPipelineStep.this.downloadStrategyOverride);
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(TaskListener.class, EnvVars.class, FilePath.class, Launcher.class, Node.class));
        }

        public String getFunctionName() {
            return DetectPipelineStep.PIPELINE_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return DetectPipelineStep.DISPLAY_NAME;
        }
    }
}

