/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.blackducksoftware.common.base.ExtraThrowables;
import com.blackducksoftware.common.value.Product;
import com.blackducksoftware.common.value.Rules;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ProductList
implements Iterable<Product> {
    private final ImmutableList<Product> products;

    public static Collector<? super Product, ?, ProductList> toProductList() {
        return Collector.of(Builder::new, Builder::addProduct, Builder::combine, Builder::build, new Collector.Characteristics[0]);
    }

    private ProductList(Builder builder) {
        Preconditions.checkArgument((!builder.products.isEmpty() ? 1 : 0) != 0, (Object)"product list requires at least one product identifier");
        this.products = (ImmutableList)builder.products.stream().distinct().collect(ImmutableList.toImmutableList());
    }

    public Product primary() {
        return (Product)this.products.get(0);
    }

    public Optional<Product> tryFind(Predicate<Product> predicate) {
        for (Product product : this.products) {
            if (!predicate.test(product)) continue;
            return Optional.of(product);
        }
        return Optional.empty();
    }

    @Override
    public Iterator<Product> iterator() {
        return this.products.iterator();
    }

    public Stream<Product> stream() {
        return this.products.stream();
    }

    public int hashCode() {
        return Objects.hash(this.products);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProductList) {
            ProductList other = (ProductList)obj;
            return this.products.equals(other.products);
        }
        return false;
    }

    public String toString() {
        return this.products.stream().map(Product::toString).collect(Collectors.joining(" "));
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static ProductList of(Product product) {
        return new Builder().addProduct(product).build();
    }

    public static ProductList valueOf(String input) {
        return ProductList.parse(input);
    }

    public static ProductList parse(CharSequence input) {
        Builder builder = new Builder();
        builder.parse(input);
        return builder.build();
    }

    public static Optional<ProductList> tryFrom(@Nullable Object obj) {
        if (obj instanceof ProductList) {
            return Optional.of((ProductList)obj);
        }
        if (obj instanceof Product) {
            return Optional.of(ProductList.of((Product)obj));
        }
        if (obj instanceof CharSequence) {
            return Optional.of(ProductList.parse((CharSequence)obj));
        }
        return Optional.empty();
    }

    public static ProductList from(Object obj) {
        return ProductList.tryFrom(Objects.requireNonNull(obj)).orElseThrow(ExtraThrowables.illegalArgument("unexpected input: %s", obj));
    }

    public static class Builder {
        private List<Product> products;

        public Builder() {
            this.products = new ArrayList<Product>();
        }

        private Builder(ProductList productList) {
            this.products = new ArrayList<Product>((Collection<Product>)productList.products);
        }

        public Builder addProduct(Product product) {
            this.products.add(Objects.requireNonNull(product));
            return this;
        }

        public Builder mergeProduct(Product product) {
            Objects.requireNonNull(product);
            ListIterator<Product> i = this.products.listIterator();
            while (i.hasNext()) {
                Product existing = i.next();
                if (!existing.name().equals(product.name())) continue;
                Product.Builder builder = existing.newBuilder();
                if (existing.version() == null) {
                    builder.version(product.version());
                }
                for (String comment : product.comments()) {
                    if (existing.comments().contains(comment)) continue;
                    builder.addComment(comment);
                }
                i.set(builder.build());
                return this;
            }
            i.add(product);
            return this;
        }

        public ProductList build() {
            return new ProductList(this);
        }

        Builder combine(Builder b) {
            this.products.addAll(b.products);
            return this;
        }

        void parse(CharSequence input) {
            Product.Builder builder = new Product.Builder();
            ArrayList tokens = new ArrayList();
            Rules.remainingTokens(input, 0, tokens::add);
            int i = 0;
            while (i < tokens.size()) {
                builder.parse((CharSequence)tokens.get(i));
                while (++i < tokens.size() && Rules.matchesWithQuotes((CharSequence)tokens.get(i), '(', ')', x -> true)) {
                    builder.addComment((CharSequence)tokens.get(i));
                }
                this.addProduct(builder.build());
            }
        }
    }
}

