/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.value;

import com.blackducksoftware.common.base.ExtraThrowables;
import com.blackducksoftware.common.value.Rules;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Multimap;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ContentType {
    private static final String CHARSET_ATTRIBUTE = "charset";
    private final String type;
    private final String subtype;
    private final ImmutableListMultimap<String, String> parameters;

    private ContentType(Builder builder) {
        this.type = Ascii.toLowerCase((String)builder.type);
        this.subtype = Ascii.toLowerCase((String)builder.subtype);
        ImmutableListMultimap.Builder parameters = ImmutableListMultimap.builder();
        for (Map.Entry parameter : builder.parameters.entries()) {
            String attribute = Ascii.toLowerCase((String)((String)parameter.getKey()));
            String value = (String)parameter.getValue();
            if (attribute.equals(CHARSET_ATTRIBUTE) && Charset.isSupported(value)) {
                value = Charset.forName(value).name();
            }
            parameters.put((Object)attribute, (Object)value);
        }
        this.parameters = parameters.build();
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public List<String> parameter(String attribute) {
        return this.parameters.get((Object)attribute);
    }

    public Charset charset() {
        if (this.is("application", "json") || this.hasSuffix("json")) {
            return StandardCharsets.UTF_8;
        }
        return ((Optional)this.parameter(CHARSET_ATTRIBUTE).stream().map(Charset::forName).collect(MoreCollectors.toOptional())).orElseGet(() -> {
            if (this.is("text", "plain")) {
                return StandardCharsets.US_ASCII;
            }
            if (this.is("application", "xml") || this.is("text", "xml")) {
                return StandardCharsets.UTF_8;
            }
            throw new UnsupportedOperationException("no charset available for: " + this.toString());
        });
    }

    public boolean hasSuffix(CharSequence suffix) {
        int pos = this.subtype.length() - suffix.length();
        return pos > 0 && this.subtype.charAt(pos - 1) == '+' && Ascii.equalsIgnoreCase((CharSequence)this.subtype.subSequence(pos, this.subtype.length()), (CharSequence)suffix);
    }

    public boolean is(CharSequence type, CharSequence subtype) {
        return Ascii.equalsIgnoreCase((CharSequence)this.type, (CharSequence)type) && Ascii.equalsIgnoreCase((CharSequence)this.subtype, (CharSequence)subtype);
    }

    public boolean is(ContentType other) {
        return this.is(other.type, other.subtype) && this.parameters.entries().containsAll((Collection)other.parameters.entries());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype, this.parameters);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContentType) {
            ContentType other = (ContentType)obj;
            return this.is(other.type, other.subtype) && this.parameters.equals(other.parameters);
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.type).append('/').append(this.subtype);
        for (Map.Entry parameter : this.parameters.entries()) {
            result.append(';').append((String)parameter.getKey()).append('=').append((String)parameter.getValue());
        }
        return result.toString();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static ContentType valueOf(String input) {
        return ContentType.parse(input);
    }

    public static ContentType parse(CharSequence input) {
        Builder builder = new Builder();
        builder.parse(input);
        return builder.build();
    }

    public static Optional<ContentType> tryFrom(@Nullable Object obj) {
        if (obj instanceof ContentType) {
            return Optional.of((ContentType)obj);
        }
        if (obj instanceof CharSequence) {
            return Optional.of(ContentType.parse((CharSequence)obj));
        }
        return Optional.empty();
    }

    public static ContentType from(Object obj) {
        return ContentType.tryFrom(Objects.requireNonNull(obj)).orElseThrow(ExtraThrowables.illegalArgument("unexpected input: %s", obj));
    }

    public static class Builder {
        private String type;
        private String subtype;
        private ListMultimap<String, String> parameters;

        public Builder() {
            this.parameters = LinkedListMultimap.create();
        }

        private Builder(ContentType contentType) {
            this.type = contentType.type;
            this.subtype = contentType.subtype;
            this.parameters = LinkedListMultimap.create((Multimap)contentType.parameters);
        }

        public Builder type(CharSequence type) {
            this.type = Rules.checkType(type);
            return this;
        }

        public Builder subtype(CharSequence subtype) {
            this.subtype = Rules.checkSubtype(subtype);
            return this;
        }

        public Builder parameter(CharSequence attribute, CharSequence value) {
            this.parameters.put((Object)Rules.checkAttribute(attribute), (Object)Rules.checkValue(value));
            return this;
        }

        public Builder text() {
            return this.type("text");
        }

        public Builder text(String charsetName) {
            return this.text().parameter(ContentType.CHARSET_ATTRIBUTE, charsetName);
        }

        public Builder text(Charset charset) {
            return this.text(charset.name());
        }

        public Builder image() {
            return this.type("image");
        }

        public Builder audio() {
            return this.type("audio");
        }

        public Builder video() {
            return this.type("video");
        }

        public Builder application() {
            return this.type("application");
        }

        public Builder multipart(CharSequence boundary) {
            return this.type("multipart").standard("mixed").parameter("boundary", boundary);
        }

        public Builder message() {
            return this.type("message");
        }

        public Builder font() {
            return this.type("font");
        }

        public Builder model() {
            return this.type("model");
        }

        public Builder standard(CharSequence subtype) {
            Objects.requireNonNull(subtype);
            return this.subtype(subtype);
        }

        public Builder standard(CharSequence subtype, CharSequence suffix) {
            Objects.requireNonNull(subtype);
            Objects.requireNonNull(suffix);
            return this.subtype(new StringBuilder().append(subtype).append('+').append(suffix));
        }

        public Builder subtype(CharSequence tree, CharSequence subtype) {
            Objects.requireNonNull(tree);
            Objects.requireNonNull(subtype);
            return this.subtype(new StringBuilder().append(tree).append('.').append(subtype));
        }

        public Builder subtype(CharSequence tree, CharSequence subtype, CharSequence suffix) {
            Objects.requireNonNull(tree);
            Objects.requireNonNull(subtype);
            Objects.requireNonNull(suffix);
            return this.subtype(new StringBuilder().append(tree).append('.').append(subtype).append('+').append(suffix));
        }

        public Builder vendor(CharSequence subtype) {
            return this.subtype("vnd", subtype);
        }

        public Builder vendor(CharSequence subtype, CharSequence suffix) {
            return this.subtype("vnd", subtype, suffix);
        }

        public Builder producer(CharSequence producer, CharSequence subtype) {
            return this.vendor(new StringBuilder().append(producer).append('.').append(subtype));
        }

        public Builder producer(CharSequence producer, CharSequence subtype, CharSequence suffix) {
            return this.vendor(new StringBuilder().append(producer).append('.').append(subtype), suffix);
        }

        public Builder personal(CharSequence subtype) {
            return this.subtype("prs", subtype);
        }

        public Builder personal(CharSequence subtype, CharSequence suffix) {
            return this.subtype("prs", subtype, suffix);
        }

        public Builder unregistered(CharSequence subtype) {
            return this.subtype("x", subtype);
        }

        public Builder unregistered(CharSequence subtype, CharSequence suffix) {
            return this.subtype("x", subtype, suffix);
        }

        public ContentType build() {
            return new ContentType(this);
        }

        void parse(CharSequence input) {
            int end = 0;
            this.parameters.clear();
            int start = end;
            end = Rules.nextRegName(input, start);
            Preconditions.checkArgument((end > start ? 1 : 0) != 0, (String)"missing type: %s", (Object)input);
            this.type(input.subSequence(start, end));
            start = end;
            end = Rules.nextChar(input, start, '/');
            Preconditions.checkArgument((end > start ? 1 : 0) != 0, (String)"missing delimiter: %s", (Object)input);
            start = end;
            end = Rules.nextRegName(input, start);
            Preconditions.checkArgument((end > start ? 1 : 0) != 0, (String)"missing subtype: %s", (Object)input);
            this.subtype(input.subSequence(start, end));
            start = end;
            end = Rules.remainingNameValues(Rules.TokenType.RFC2045, input, start, this::parameter);
            Preconditions.checkArgument((end == input.length() ? 1 : 0) != 0, (String)"invalid parameters: %s", (Object)input);
        }
    }
}

