/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.security.auth;

import com.blackducksoftware.common.base.ExtraOptionals;
import com.blackducksoftware.common.base.ExtraStrings;
import com.blackducksoftware.common.security.auth.InvalidCertificateCallback;
import com.blackducksoftware.common.security.cert.X509Certificates;
import com.google.common.net.InternetDomainName;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;

public final class InvalidCertificateChainCallback
extends InvalidCertificateCallback {
    private static final long serialVersionUID = -374147648020177306L;
    private final X509Certificate[] chain;
    private final String authType;

    public InvalidCertificateChainCallback(X509Certificate[] chain, String authType) {
        super(InvalidCertificateChainCallback.getName(chain[0]));
        this.chain = Objects.requireNonNull(chain);
        this.authType = Objects.requireNonNull(authType);
    }

    public X509Certificate[] getCertificateChain() {
        return this.chain;
    }

    public String getAuthType() {
        return this.authType;
    }

    private static String getName(X509Certificate cert) {
        Optional<String> name = Optional.empty();
        name = ExtraOptionals.or(name, () -> X509Certificates.subjectAlternativeDnsNames(cert).findFirst());
        name = ExtraOptionals.or(name, () -> X509Certificates.subjectCommonName(cert).filter(InternetDomainName::isValid));
        name = ExtraOptionals.or(name, () -> ExtraStrings.ofEmpty(cert.getSubjectX500Principal().getName()));
        return name.orElse("<unknown host>");
    }
}

