/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.security.auth;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.security.auth.callback.ChoiceCallback;

public class EnumChoiceCallback<E extends Enum<E>>
extends ChoiceCallback {
    private static final long serialVersionUID = 5534324499615987270L;
    private final Class<E> choices;

    public EnumChoiceCallback(String prompt, Class<E> choices, E defaultChoice, boolean multipleSelectionsAllowed, ResourceBundle bundle) {
        super(prompt, EnumChoiceCallback.choices(choices, bundle), ((Enum)defaultChoice).ordinal(), multipleSelectionsAllowed);
        this.choices = Objects.requireNonNull(choices);
    }

    private static <E extends Enum<E>> String[] choices(Class<E> choices, ResourceBundle bundle) {
        return (String[])Stream.of((Enum[])choices.getEnumConstants()).map(Enum::name).map(bundle::getString).toArray(String[]::new);
    }

    public void setSelectedChoice(E choice) {
        this.setSelectedIndex(((Enum)choice).ordinal());
    }

    public void setSelectedChoices(E ... choices) {
        this.setSelectedIndexes(Stream.of(choices).mapToInt(Enum::ordinal).toArray());
    }

    public void setSelectedChoices(Iterable<E> choices) {
        this.setSelectedIndexes(StreamSupport.stream(choices.spliterator(), false).mapToInt(Enum::ordinal).toArray());
    }

    public Optional<E> getSelectedChoice() {
        int[] selectedIndexes = this.getSelectedIndexes();
        if (selectedIndexes != null && selectedIndexes.length > 0) {
            return IntStream.of(selectedIndexes).mapToObj(i -> ((Enum[])this.choices.getEnumConstants())[i]).findFirst();
        }
        return Optional.empty();
    }

    public List<E> getSelectedChoices() {
        int[] selectedIndexes = this.getSelectedIndexes();
        if (selectedIndexes != null && selectedIndexes.length > 0) {
            return IntStream.of(selectedIndexes).mapToObj(i -> ((Enum[])this.choices.getEnumConstants())[i]).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return Collections.emptyList();
    }
}

