/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.nio.file;

import java.util.EnumSet;

class FnMatch {
    private static final int RANGE_ERROR = -1;
    private static final int RANGE_NOMATCH = 0;

    FnMatch() {
    }

    public static boolean fnmatch(String pattern, String string, EnumSet<Flag> flags) {
        return FnMatch.match(pattern, 0, string, 0, flags);
    }

    public static boolean fnmatch(String pattern, String string, int stringPos, Flag flag) {
        return FnMatch.match(pattern, 0, string, stringPos, EnumSet.of(flag));
    }

    public static boolean fnmatch(String pattern, String string, int stringPos) {
        return FnMatch.match(pattern, 0, string, stringPos, EnumSet.noneOf(Flag.class));
    }

    public static boolean fnmatch(String pattern, String string) {
        return FnMatch.fnmatch(pattern, string, 0);
    }

    private static boolean match(String pattern, int patternPos, String string, int stringPos, EnumSet<Flag> flags) {
        block6: while (true) {
            if (patternPos >= pattern.length()) {
                if (flags.contains((Object)Flag.LEADING_DIR) && string.charAt(stringPos) == '/') {
                    return true;
                }
                return stringPos == string.length();
            }
            char c = pattern.charAt(patternPos++);
            switch (c) {
                case '?': {
                    if (stringPos >= string.length()) {
                        return false;
                    }
                    if (string.charAt(stringPos) == '/' && flags.contains((Object)Flag.PATHNAME)) {
                        return false;
                    }
                    if (FnMatch.hasLeadingPeriod(string, stringPos, flags)) {
                        return false;
                    }
                    ++stringPos;
                    continue block6;
                }
                case '*': {
                    while (patternPos < pattern.length() && (c = pattern.charAt(patternPos)) == '*') {
                        ++patternPos;
                    }
                    if (FnMatch.hasLeadingPeriod(string, stringPos, flags)) {
                        return false;
                    }
                    if (patternPos == pattern.length()) {
                        if (flags.contains((Object)Flag.PATHNAME)) {
                            return flags.contains((Object)Flag.LEADING_DIR) || string.indexOf(47, stringPos) == -1;
                        }
                        return true;
                    }
                    if (c == '/' && flags.contains((Object)Flag.PATHNAME)) {
                        if ((stringPos = string.indexOf(47, stringPos)) != -1) continue block6;
                        return false;
                    }
                    while (stringPos < string.length()) {
                        if (flags.contains((Object)Flag.PERIOD)) {
                            flags = EnumSet.copyOf(flags);
                            flags.remove((Object)Flag.PERIOD);
                        }
                        if (FnMatch.match(pattern, patternPos, string, stringPos, flags)) {
                            return true;
                        }
                        if (string.charAt(stringPos) == '/' && flags.contains((Object)Flag.PATHNAME)) break;
                        ++stringPos;
                    }
                    return false;
                }
                case '[': {
                    if (stringPos >= string.length()) {
                        return false;
                    }
                    if (string.charAt(stringPos) == '/' && flags.contains((Object)Flag.PATHNAME)) {
                        return false;
                    }
                    if (FnMatch.hasLeadingPeriod(string, stringPos, flags)) {
                        return false;
                    }
                    int result = FnMatch.matchRange(pattern, patternPos, string.charAt(stringPos), flags);
                    if (result == -1) break;
                    if (result == 0) {
                        return false;
                    }
                    patternPos = result;
                    ++stringPos;
                    continue block6;
                }
                case '\\': {
                    if (flags.contains((Object)Flag.NOESCAPE)) break;
                    c = patternPos >= pattern.length() ? (char)'\\' : (char)pattern.charAt(patternPos++);
                }
            }
            if (stringPos >= string.length()) {
                return false;
            }
            if (!(c == string.charAt(stringPos) || flags.contains((Object)Flag.CASEFOLD) && Character.toLowerCase(c) == Character.toLowerCase(string.charAt(stringPos)))) {
                return false;
            }
            ++stringPos;
        }
    }

    private static boolean hasLeadingPeriod(String string, int stringPos, EnumSet<Flag> flags) {
        if (stringPos > string.length() - 1) {
            return false;
        }
        return (stringPos == 0 || flags.contains((Object)Flag.PATHNAME) && string.charAt(stringPos - 1) == '/') && string.charAt(stringPos) == '.' && flags.contains((Object)Flag.PERIOD);
    }

    private static int matchRange(String pattern, int patternPos, char test, EnumSet<Flag> flags) {
        boolean negate;
        if (patternPos >= pattern.length()) {
            return -1;
        }
        char c = pattern.charAt(patternPos);
        boolean bl = negate = c == '!' || c == '^';
        if (negate) {
            ++patternPos;
        }
        if (flags.contains((Object)Flag.CASEFOLD)) {
            test = Character.toLowerCase(test);
        }
        boolean ok = false;
        while (true) {
            char c2;
            if (patternPos >= pattern.length()) {
                return -1;
            }
            if ((c = pattern.charAt(patternPos++)) == ']') break;
            if (c == '\\' && !flags.contains((Object)Flag.NOESCAPE)) {
                c = pattern.charAt(patternPos++);
            }
            if (c == '/' && flags.contains((Object)Flag.PATHNAME)) {
                return 0;
            }
            if (flags.contains((Object)Flag.CASEFOLD)) {
                c = Character.toLowerCase(c);
            }
            if (pattern.charAt(patternPos) == '-' && patternPos + 1 < pattern.length() && (c2 = pattern.charAt(patternPos + 1)) != ']') {
                patternPos += 2;
                if (c2 == '\\' && !flags.contains((Object)Flag.NOESCAPE)) {
                    if (patternPos >= pattern.length()) {
                        return -1;
                    }
                    c = pattern.charAt(patternPos++);
                }
                if (flags.contains((Object)Flag.CASEFOLD)) {
                    c2 = Character.toLowerCase(c2);
                }
                if (c > test || test > c2) continue;
                ok = true;
                continue;
            }
            if (c != test) continue;
            ok = true;
        }
        return ok == negate ? 0 : patternPos;
    }

    public static enum Flag {
        NOESCAPE,
        PATHNAME,
        PERIOD,
        LEADING_DIR,
        CASEFOLD;

    }
}

