/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.nio.file;

import com.blackducksoftware.common.base.ExtraStrings;
import com.blackducksoftware.common.nio.file.FnMatch;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExcludePathMatcher
implements PathMatcher {
    private final Path top;
    private final Function<String, Stream<String>> patternNormalizer;
    private final List<String> excludePerDirectoryNames;
    private final List<PatternPathMatcher> matchers;
    private final Map<Path, List<PatternPathMatcher>> perDirectoryMatchers = new ConcurrentHashMap<Path, List<PatternPathMatcher>>();

    private ExcludePathMatcher(Builder builder) {
        this.top = Objects.requireNonNull(builder.top);
        this.patternNormalizer = Objects.requireNonNull(builder.patternNormalizer);
        this.excludePerDirectoryNames = ImmutableList.copyOf((Collection)builder.excludePerDirectoryNames);
        this.matchers = (List)Stream.concat(builder.patterns.stream(), builder.files.stream().flatMap(ExcludePathMatcher::readAllLines)).flatMap(this.patternNormalizer).map(pattern -> PatternPathMatcher.create(pattern, this.top)).sorted().collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean matches(Path path) {
        if (!path.startsWith(this.top)) {
            return false;
        }
        if (path.equals(this.top)) {
            return true;
        }
        for (PatternPathMatcher matcher : this.matchers) {
            if (!matcher.matches(path)) continue;
            return matcher.negate;
        }
        if (!this.excludePerDirectoryNames.isEmpty()) {
            for (PatternPathMatcher matcher : this.perDirectoryMatchers.computeIfAbsent(path.getParent(), this::directoryMatchers)) {
                if (!matcher.matches(path)) continue;
                return matcher.negate;
            }
        }
        return true;
    }

    private List<PatternPathMatcher> directoryMatchers(Path directory) {
        return ExcludePathMatcher.readDirectoryPatterns(this.top, this.excludePerDirectoryNames, directory).flatMap(this.patternNormalizer).map(pattern -> PatternPathMatcher.create(pattern, directory)).sorted().collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private static Stream<String> readDirectoryPatterns(Path top, List<String> excludePerDirectoryNames, Path directory) {
        Stream<String> patterns = excludePerDirectoryNames.stream().map(directory::resolve).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(ExcludePathMatcher::readAllLines);
        Path parent = directory.getParent();
        if (parent != null && parent.startsWith(top)) {
            return Stream.concat(patterns, ExcludePathMatcher.readDirectoryPatterns(top, excludePerDirectoryNames, parent));
        }
        return patterns;
    }

    private static Stream<String> readAllLines(Path file) {
        try {
            return Files.readAllLines(file, Charset.defaultCharset()).stream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Stream<String> defaultPatternNormalizer(String line) {
        if (line == null || CharMatcher.whitespace().matchesAllOf((CharSequence)line) || line.charAt(0) == '#') {
            return Stream.empty();
        }
        String pattern = line;
        if (pattern.startsWith("\\#")) {
            pattern = pattern.substring(1);
        }
        while (pattern.endsWith(" ") && !pattern.endsWith("\\ ")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        int trailingSpace = 0;
        while (pattern.endsWith("\\ ")) {
            pattern = pattern.substring(0, pattern.length() - 2);
            ++trailingSpace;
        }
        while (trailingSpace-- > 0) {
            pattern = pattern + " ";
        }
        return Stream.of(pattern);
    }

    public static class Builder {
        private Path top;
        private Function<String, Stream<String>> patternNormalizer;
        private final List<String> patterns = new ArrayList<String>();
        private final List<Path> files = new ArrayList<Path>();
        private final List<String> excludePerDirectoryNames = new ArrayList<String>();

        public Builder() {
            this.top = Paths.get(System.getProperty("user.dir"), new String[0]);
            this.patternNormalizer = ExcludePathMatcher::defaultPatternNormalizer;
        }

        public Builder from(Path top) {
            this.top = Objects.requireNonNull(top);
            return this;
        }

        public Builder normalizingPatterns(Function<String, Stream<String>> patternNormalizer) {
            this.patternNormalizer = Objects.requireNonNull(patternNormalizer);
            return this;
        }

        public Builder exclude(String pattern) {
            this.patterns.add(Objects.requireNonNull(pattern));
            return this;
        }

        public Builder excludeFrom(Path file) {
            this.files.add(Objects.requireNonNull(file));
            return this;
        }

        public Builder excludePerDirectory(String name) {
            this.excludePerDirectoryNames.add(Objects.requireNonNull(name));
            return this;
        }

        public ExcludePathMatcher build() {
            return new ExcludePathMatcher(this);
        }
    }

    private static class PatternPathMatcher
    implements PathMatcher,
    Comparable<PatternPathMatcher> {
        private static final EnumSet<FnMatch.Flag> PATHNAME = EnumSet.of(FnMatch.Flag.PATHNAME);
        private final String pattern;
        private final Path directory;
        private final boolean negate;
        private final boolean directoriesOnly;
        private final boolean pathnameMatch;

        private PatternPathMatcher(String pattern, Path directory, boolean negate, boolean directoriesOnly, boolean pathnameMatch) {
            this.pattern = Objects.requireNonNull(pattern);
            this.directory = Objects.requireNonNull(directory);
            this.negate = negate;
            this.directoriesOnly = directoriesOnly;
            this.pathnameMatch = pathnameMatch;
        }

        private static PatternPathMatcher create(String rawPattern, Path directory) {
            boolean pathnameMatch;
            String pattern = rawPattern;
            boolean negate = false;
            boolean directoryOnly = false;
            if (pattern.charAt(0) == '!') {
                negate = true;
                pattern = pattern.substring(1);
            }
            if (pattern.startsWith("\\!")) {
                pattern = pattern.substring(1);
            }
            if (pattern.charAt(pattern.length() - 1) == '/') {
                directoryOnly = true;
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            boolean bl = pathnameMatch = pattern.indexOf(47) >= 0;
            if (pattern.charAt(0) == '/') {
                pattern = pattern.substring(1);
            }
            return new PatternPathMatcher(pattern, directory, negate, directoryOnly, pathnameMatch);
        }

        @Override
        public int compareTo(PatternPathMatcher other) {
            return Boolean.compare(other.negate, this.negate);
        }

        @Override
        public final boolean matches(Path path) {
            Path relativePath = this.directory.relativize(path);
            boolean matches = false;
            if (this.pathnameMatch) {
                matches = FnMatch.fnmatch(this.pattern, ExtraStrings.ensureDelimiter(relativePath, "/"), PATHNAME);
            } else {
                for (int i = 0; i < relativePath.getNameCount() && !matches; ++i) {
                    matches = FnMatch.fnmatch(this.pattern, relativePath.getName(i).toString());
                }
            }
            return matches && (!this.directoriesOnly || Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS));
        }

        public String toString() {
            return "PatternPathMatcher{'" + this.pattern + "', negate=" + this.negate + ", dir=" + this.directoriesOnly + ", pn=" + this.pathnameMatch + "}";
        }
    }
}

