/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.net;

import com.blackducksoftware.common.base.ExtraStreams;
import com.blackducksoftware.common.base.ExtraStrings;
import com.google.common.annotations.Beta;
import com.google.common.net.InetAddresses;
import java.net.IDN;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.stream.Stream;

@Beta
public class Hostname {
    private static final String LOOPBACK_HOSTNAME = "localhost";

    public static String get() {
        try {
            return Hostname.hostname(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            return Hostname.allInetAddresses().map(Hostname::hostname).filter(Hostname::isNotInetAddress).findFirst().orElse(LOOPBACK_HOSTNAME);
        }
    }

    public static String getAscii() {
        try {
            return IDN.toASCII(Hostname.get(), 2);
        }
        catch (IllegalArgumentException e) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ee) {
                return Hostname.allInetAddresses().map(InetAddress::getHostAddress).findFirst().orElse(InetAddress.getLoopbackAddress().getHostAddress());
            }
        }
    }

    private static String hostname(InetAddress addr) {
        if (addr.isLoopbackAddress()) {
            return LOOPBACK_HOSTNAME;
        }
        String fqdn = addr.getCanonicalHostName();
        return Hostname.isNotInetAddress(fqdn) ? fqdn : addr.getHostName();
    }

    private static boolean isNotInetAddress(String addr) {
        return !InetAddresses.isInetAddress((String)ExtraStrings.beforeFirst(addr, '%'));
    }

    private static Stream<InetAddress> allInetAddresses() {
        try {
            return ExtraStreams.stream(NetworkInterface.getNetworkInterfaces()).filter(ni -> {
                try {
                    return ni.isUp() && !ni.isLoopback();
                }
                catch (SocketException e) {
                    return false;
                }
            }).flatMap(ni -> ExtraStreams.stream(ni.getInetAddresses()));
        }
        catch (SocketException e) {
            return Stream.empty();
        }
    }

    private Hostname() {
        assert (false);
    }
}

