/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.io;

import com.blackducksoftware.common.io.HeapChannel;
import com.blackducksoftware.common.io.HeapInputStream;
import com.google.common.base.Verify;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.util.Base64;

public class HeapOutputStream
extends ByteArrayOutputStream {
    public HeapOutputStream() {
    }

    public HeapOutputStream(int size) {
        super(size);
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public boolean hasCapacity(long size) {
        return size <= (long)this.buf.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapOutputStream transferFrom(HeapOutputStream other) {
        HeapOutputStream heapOutputStream = other;
        synchronized (heapOutputStream) {
            this.write(other.buf, 0, other.count);
        }
        return this;
    }

    public synchronized SeekableByteChannel getChannel() {
        return new HeapChannel(this.buf, 0, this.count);
    }

    public synchronized InputStream getInputStream() {
        return new HeapInputStream(this.buf, 0, this.count);
    }

    public synchronized ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count).asReadOnlyBuffer();
    }

    @Override
    public synchronized String toString(Charset charset) {
        return new String(this.buf, 0, this.count, charset);
    }

    public synchronized String toString(Base64.Encoder encoder) {
        ByteBuffer bb = encoder.encode(this.toByteBuffer());
        Verify.verify((boolean)bb.hasArray(), (String)"expected backing array", (Object[])new Object[0]);
        return new String(bb.array(), 0, bb.arrayOffset() + bb.position(), bb.remaining());
    }
}

