/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.io;

import com.google.common.annotations.Beta;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class HeapChannel
implements SeekableByteChannel {
    private final Set<StandardOpenOption> openOptions;
    private byte[] buf;
    private int off;
    private int pos;
    private int count;

    @Beta
    public HeapChannel(int size) {
        this.openOptions = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.buf = new byte[size];
    }

    public HeapChannel(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public HeapChannel(byte[] buf, int off, int len) {
        this.openOptions = EnumSet.of(StandardOpenOption.READ);
        this.buf = buf;
        this.off = off;
        this.count = (int)Math.min((long)off + (long)len, (long)buf.length);
    }

    @Override
    public boolean isOpen() {
        return !this.openOptions.isEmpty();
    }

    @Override
    public void close() {
        this.openOptions.clear();
    }

    @Override
    public int read(ByteBuffer dst) throws ClosedChannelException {
        Objects.requireNonNull(dst);
        this.requireOpen(StandardOpenOption.READ);
        if (this.pos < this.count) {
            int len = Math.min(dst.remaining(), this.count - this.off - this.pos);
            dst.put(this.buf, this.off + this.pos, len);
            this.pos += len;
            return len;
        }
        return -1;
    }

    @Override
    public int write(ByteBuffer src) throws ClosedChannelException, NonWritableChannelException {
        Objects.requireNonNull(src);
        this.requireOpen(StandardOpenOption.WRITE);
        int start = this.pos;
        int end = start + src.remaining();
        if (end > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, end);
        }
        src.get(this.buf, start, end - start);
        this.pos = end;
        this.count = Math.max(this.count, end);
        return end - start;
    }

    @Override
    public long position() throws ClosedChannelException {
        this.requireOpen(new StandardOpenOption[0]);
        return this.pos;
    }

    @Override
    public HeapChannel position(long newPosition) throws ClosedChannelException {
        this.requireOpen(new StandardOpenOption[0]);
        if (newPosition < 0L) {
            throw new IllegalArgumentException("newPosition must be non-negative");
        }
        this.pos = newPosition < Integer.MAX_VALUE ? (int)newPosition : Integer.MAX_VALUE;
        return this;
    }

    @Override
    public long size() throws ClosedChannelException {
        this.requireOpen(new StandardOpenOption[0]);
        return (long)this.count - (long)this.off;
    }

    @Override
    public HeapChannel truncate(long size) throws ClosedChannelException {
        this.requireOpen(StandardOpenOption.WRITE);
        if (size < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        this.count = size < Integer.MAX_VALUE ? Math.min((int)size, this.buf.length - this.off) : this.buf.length - this.off;
        if (this.pos > this.count) {
            this.pos = this.count;
        }
        return this;
    }

    private void requireOpen(StandardOpenOption ... options) throws ClosedChannelException, NonReadableChannelException, NonWritableChannelException {
        if (this.openOptions.isEmpty()) {
            throw new ClosedChannelException();
        }
        for (StandardOpenOption option : options) {
            if (this.openOptions.contains(option)) continue;
            switch (option) {
                case READ: {
                    throw new NonReadableChannelException();
                }
                case WRITE: {
                    throw new NonWritableChannelException();
                }
            }
            throw new IllegalStateException("unsupported open option: " + option);
        }
    }
}

