/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.io;

import com.blackducksoftware.common.base.ExtraStrings;
import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import javax.annotation.Nullable;

@Beta
public class Formatter<T> {
    private final Map<Character, Placeholder<T>> placeholders = new HashMap<Character, Placeholder<T>>();
    private final Map<String, String> prettyFormats = new HashMap<String, String>();
    private String delimiter = "\n";

    public Formatter() {
        this.placeholders.put(Character.valueOf('n'), (v, o) -> "\n");
        this.placeholders.put(Character.valueOf('%'), (v, o) -> "%");
        this.placeholders.put(Character.valueOf('x'), HexBytePlaceholder.getInstance());
        this.placeholders.put(Character.valueOf('C'), new ColorPlaceholder());
        this.placeholders.put(Character.valueOf('<'), new PaddingPlaceholder('<'));
        this.placeholders.put(Character.valueOf('>'), new PaddingPlaceholder('>'));
    }

    public void setPlaceholder(char c, @Nullable Placeholder<T> placeholder) {
        this.placeholders.put(Character.valueOf(c), placeholder);
    }

    public void setPlaceholder(char c, Function<T, String> extractor) {
        this.setPlaceholder(c, new LambdaPlaceholder<T>(extractor));
    }

    public void setPrettyFormat(String pretty, String format) {
        this.prettyFormats.put(Objects.requireNonNull(pretty), Objects.requireNonNull(format));
    }

    public void setPrettyFormats(String shortFormat, String mediumFormat, String fullFormat) {
        this.prettyFormats.put("short", Objects.requireNonNull(shortFormat));
        this.prettyFormats.put("medium", Objects.requireNonNull(mediumFormat));
        this.prettyFormats.put("full", Objects.requireNonNull(fullFormat));
    }

    public void setDelimiter(CharSequence delimiter) {
        this.delimiter = delimiter.toString();
    }

    public String format(T obj, String pretty) {
        return this.formatTo(new StringBuilder(), obj, pretty).toString();
    }

    public <A extends Appendable> A formatTo(A target, T obj, String pretty) {
        Objects.requireNonNull(obj);
        try {
            String format;
            boolean terminate = false;
            if (pretty.startsWith("tformat:")) {
                format = pretty.substring(8);
                terminate = true;
            } else if (pretty.startsWith("format:")) {
                format = pretty.substring(7);
            } else {
                format = this.prettyFormats.get(pretty);
                Preconditions.checkArgument((format != null ? 1 : 0) != 0, (String)"invalid format: %s", (Object)format);
            }
            int start = 0;
            int end = format.indexOf(37);
            Function<Object, Object> adjustment = Function.identity();
            while (end >= 0) {
                Placeholder<T> placeholder;
                target.append(format, start, end);
                char p = format.charAt(++end);
                if (p == '+' || p == '-' || p == ' ') {
                    if (p == '+') {
                        adjustment = v -> v.isEmpty() ? "" : "\n" + v;
                    } else if (p == ' ') {
                        adjustment = v -> v.isEmpty() ? "" : " " + v;
                    } else {
                        throw new UnsupportedOperationException("cannot take back newlines");
                    }
                    p = format.charAt(++end);
                }
                Preconditions.checkArgument(((placeholder = this.placeholders.get(Character.valueOf(p))) != null ? 1 : 0) != 0, (String)"invalid placeholder: %s", (char)p);
                String options = format.substring(++end, end + placeholder.optionLength(format, end));
                if (placeholder instanceof PaddingPlaceholder) {
                    adjustment = ((PaddingPlaceholder)placeholder).adjust(options);
                } else {
                    String value = placeholder.extract(obj, options);
                    value = (String)adjustment.apply(value);
                    adjustment = Function.identity();
                    target.append(value);
                }
                start = end + options.length();
                end = format.indexOf(37, start);
            }
            target.append(format, start, format.length());
            if (terminate) {
                target.append(this.delimiter);
            }
            return target;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class PaddingPlaceholder<T>
    implements Placeholder<T> {
        private final char placeholder;

        public PaddingPlaceholder(char placeholder) {
            this.placeholder = placeholder;
        }

        private String padding(CharSequence format, int offset) {
            StringBuilder result = new StringBuilder(3).append(this.placeholder);
            char c = format.charAt(offset++);
            while (c == '|' || c == '<' || c == '>') {
                result.append(c);
                c = format.charAt(offset++);
            }
            return result.toString();
        }

        @Override
        public int optionLength(CharSequence format, int offset) {
            int l = this.padding(format, offset).length() - 1;
            return Placeholder.optionsGroupLength(format, offset + l) + l;
        }

        public Function<String, String> adjust(String options) {
            Function<Object, Object> truncate;
            String padding = this.padding(options, 0);
            List<String> optionsGroup = Placeholder.optionsGroup(options.substring(padding.length() - 1));
            Preconditions.checkArgument((optionsGroup.size() == 1 || optionsGroup.size() == 2 ? 1 : 0) != 0, (String)"invalid format, bad padding options", (Object)options);
            int n = Integer.parseInt(optionsGroup.get(0));
            switch (padding.endsWith("|") || optionsGroup.size() < 2 ? "" : optionsGroup.get(1)) {
                case "": {
                    truncate = Function.identity();
                    break;
                }
                case "trunc": {
                    truncate = v -> ExtraStrings.truncateEnd(v, n);
                    break;
                }
                case "ltrunc": {
                    truncate = v -> ExtraStrings.truncateStart(v, n);
                    break;
                }
                case "mtrunc": {
                    truncate = v -> ExtraStrings.truncateMiddle(v, n);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid format, bad truncate option: " + options);
                }
            }
            Function<String, String> pad = padding.startsWith("><") ? v -> ExtraStrings.padBoth(v, n, ' ') : (padding.startsWith("<") ? v -> Strings.padEnd((String)v, (int)n, (char)' ') : v -> Strings.padStart((String)v, (int)n, (char)' '));
            return truncate.andThen(pad);
        }

        @Override
        public String extract(T value, String options) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ColorPlaceholder<T>
    implements Placeholder<T> {
        private static final ImmutableSet<String> OPTIONS = ImmutableSet.of((Object)"red", (Object)"green", (Object)"blue", (Object)"reset");
        private static final ImmutableList<String> COLORS = ImmutableList.of((Object)"black", (Object)"red", (Object)"green", (Object)"yellow", (Object)"blue", (Object)"magenta", (Object)"cyan", (Object)"white");
        private static final ImmutableList<String> ATTRIBUTES = ImmutableList.of((Object)"reset", (Object)"bold", (Object)"dim", (Object)"italic", (Object)"ul", (Object)"blink", (Object)"", (Object)"", (Object)"", (Object)"strike");
        private Boolean enabled;

        private ColorPlaceholder() {
        }

        private boolean useColor() {
            if (this.enabled == null) {
                return System.console() != null;
            }
            return this.enabled;
        }

        @Override
        public int optionLength(CharSequence format, int offset) {
            int len = Placeholder.optionsGroupLength(format, offset);
            if (len > 0) {
                return len;
            }
            for (String option : OPTIONS) {
                if (!option.contentEquals(format.subSequence(offset, Math.min(offset + option.length(), format.length())))) continue;
                return option.length();
            }
            throw new IllegalArgumentException("invalid format, incorrect color: " + format);
        }

        @Override
        public String extract(Object value, String options) {
            if (OPTIONS.contains((Object)options)) {
                return this.ansi(options, false);
            }
            List<String> optionsGroup = Placeholder.optionsGroup(options);
            Preconditions.checkArgument((optionsGroup != null ? 1 : 0) != 0, (String)"invalid format, unsupported options: %s", (Object)options);
            StringBuilder result = new StringBuilder();
            int colorIndex = 0;
            for (String option : optionsGroup) {
                if (COLORS.contains((Object)option) || option.startsWith("#")) {
                    Preconditions.checkArgument((colorIndex < 2 ? 1 : 0) != 0, (Object)("invalid format, too many colors: " + options));
                    result.append(this.ansi(option, colorIndex++ == 1));
                    continue;
                }
                if (option.equals("auto") && optionsGroup.size() == 1) {
                    this.enabled = null;
                    continue;
                }
                if (option.equals("always")) {
                    this.enabled = Boolean.TRUE;
                    continue;
                }
                boolean invert = option.startsWith("no");
                result.append(this.ansi(invert ? ExtraStrings.removePrefix(ExtraStrings.removePrefix(option, "no"), "-") : option, invert));
            }
            return result.toString();
        }

        private String ansi(String value, boolean toggle) {
            Preconditions.checkArgument((!value.equals("reset") || !toggle ? 1 : 0) != 0, (Object)("invalid ANSI tag: " + value));
            if (!this.useColor()) {
                return "";
            }
            if (value.startsWith("#") && value.length() == 7) {
                int color = Integer.parseInt(value.substring(1), 16);
                return "\u001b[" + (toggle ? 48 : 38) + ";2;" + (color >> 16 & 0xFF) + ";" + (color >> 8 & 0xFF) + ";" + (color & 0xFF) + "m";
            }
            int color = COLORS.indexOf((Object)value);
            if (color >= 0) {
                return "\u001b[" + (color + (toggle ? 40 : 30)) + "m";
            }
            int attribute = ATTRIBUTES.indexOf((Object)value);
            if (attribute >= 0) {
                return "\u001b[" + (attribute + (toggle ? 20 : 0)) + "m";
            }
            throw new IllegalArgumentException("unknown ANSI tag: " + value);
        }
    }

    private static class HexBytePlaceholder
    implements Placeholder<Object> {
        private static final HexBytePlaceholder INSTANCE = new HexBytePlaceholder();

        private HexBytePlaceholder() {
        }

        public static <T> Placeholder<T> getInstance() {
            return INSTANCE;
        }

        @Override
        public int optionLength(CharSequence format, int offset) {
            return 2;
        }

        @Override
        public String extract(Object value, String options) {
            return new String(new byte[]{Byte.parseByte(options, 16)}, StandardCharsets.US_ASCII);
        }
    }

    private static class LambdaPlaceholder<T>
    implements Placeholder<T> {
        private final ToIntBiFunction<CharSequence, Integer> optionLength;
        private final BiFunction<T, String, String> extract;

        public LambdaPlaceholder(ToIntBiFunction<CharSequence, Integer> optionLength, BiFunction<T, String, String> extract) {
            this.optionLength = Objects.requireNonNull(optionLength);
            this.extract = Objects.requireNonNull(extract);
        }

        public LambdaPlaceholder(Function<T, String> extract) {
            this((f, o) -> 0, (v, o) -> (String)extract.apply(v));
        }

        @Override
        public int optionLength(CharSequence format, int offset) {
            return this.optionLength.applyAsInt(format, offset);
        }

        @Override
        public String extract(T value, String options) {
            return this.extract.apply(value, options);
        }
    }

    public static interface Placeholder<T> {
        default public int optionLength(CharSequence format, int offset) {
            return 0;
        }

        public String extract(T var1, String var2);

        public static int optionsGroupLength(CharSequence format, int offset) {
            if (format.charAt(offset) == '(') {
                for (int i = offset; i < format.length(); ++i) {
                    if (format.charAt(i) != ')') continue;
                    return i - offset + 1;
                }
                throw new IllegalArgumentException("invalid format, missing ')': " + format);
            }
            return 0;
        }

        @Nullable
        public static List<String> optionsGroup(String options) {
            if (options.startsWith("(") && options.endsWith(")")) {
                return Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" ,")).omitEmptyStrings().splitToList((CharSequence)options.substring(1, options.length() - 1));
            }
            return null;
        }
    }
}

