/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.io;

import com.blackducksoftware.common.io.ByteUnit;

public enum DecimalByteUnit implements ByteUnit
{
    BYTES{

        @Override
        public long toBytes(long c) {
            return c;
        }

        @Override
        public long toKilobytes(long c) {
            return c / 1000L;
        }

        @Override
        public long toMegabytes(long c) {
            return c / 1000000L;
        }

        @Override
        public long toGigabytes(long c) {
            return c / 1000000000L;
        }

        @Override
        public long toTerabytes(long c) {
            return c / 1000000000000L;
        }

        @Override
        public long toPetabytes(long c) {
            return c / 1000000000000000L;
        }

        @Override
        public long toExabytes(long c) {
            return c / 1000000000000000000L;
        }

        @Override
        public long convert(long c, DecimalByteUnit u) {
            return u.toBytes(c);
        }
    }
    ,
    KILOBYTES{

        @Override
        public long toBytes(long c) {
            return DecimalByteUnit.x(c, 1000L, 9223372036854775L);
        }

        @Override
        public long toKilobytes(long c) {
            return c;
        }

        @Override
        public long toMegabytes(long c) {
            return c / 1000L;
        }

        @Override
        public long toGigabytes(long c) {
            return c / 1000000L;
        }

        @Override
        public long toTerabytes(long c) {
            return c / 1000000000L;
        }

        @Override
        public long toPetabytes(long c) {
            return c / 1000000000000L;
        }

        @Override
        public long toExabytes(long c) {
            return c / 1000000000000000L;
        }

        @Override
        public long convert(long c, DecimalByteUnit u) {
            return u.toKilobytes(c);
        }
    }
    ,
    MEGABYTES{

        @Override
        public long toBytes(long c) {
            return DecimalByteUnit.x(c, 1000000L, 9223372036854L);
        }

        @Override
        public long toKilobytes(long c) {
            return DecimalByteUnit.x(c, 1000L, 9223372036854775L);
        }

        @Override
        public long toMegabytes(long c) {
            return c;
        }

        @Override
        public long toGigabytes(long c) {
            return c / 1000L;
        }

        @Override
        public long toTerabytes(long c) {
            return c / 1000000L;
        }

        @Override
        public long toPetabytes(long c) {
            return c / 1000000000L;
        }

        @Override
        public long toExabytes(long c) {
            return c / 1000000000000L;
        }

        @Override
        public long convert(long c, DecimalByteUnit u) {
            return u.toMegabytes(c);
        }
    }
    ,
    GIGABYTES{

        @Override
        public long toBytes(long c) {
            return DecimalByteUnit.x(c, 1000000000L, 9223372036L);
        }

        @Override
        public long toKilobytes(long c) {
            return DecimalByteUnit.x(c, 1000000L, 9223372036854L);
        }

        @Override
        public long toMegabytes(long c) {
            return DecimalByteUnit.x(c, 1000L, 9223372036854775L);
        }

        @Override
        public long toGigabytes(long c) {
            return c;
        }

        @Override
        public long toTerabytes(long c) {
            return c / 1000L;
        }

        @Override
        public long toPetabytes(long c) {
            return c / 1000000L;
        }

        @Override
        public long toExabytes(long c) {
            return c / 1000000000L;
        }

        @Override
        public long convert(long c, DecimalByteUnit u) {
            return u.toGigabytes(c);
        }
    }
    ,
    TERABYTES{

        @Override
        public long toBytes(long c) {
            return DecimalByteUnit.x(c, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toKilobytes(long c) {
            return DecimalByteUnit.x(c, 1000000000L, 9223372036L);
        }

        @Override
        public long toMegabytes(long c) {
            return DecimalByteUnit.x(c, 1000000L, 9223372036854L);
        }

        @Override
        public long toGigabytes(long c) {
            return DecimalByteUnit.x(c, 1000L, 9223372036854775L);
        }

        @Override
        public long toTerabytes(long c) {
            return c;
        }

        @Override
        public long toPetabytes(long c) {
            return c / 1000L;
        }

        @Override
        public long toExabytes(long c) {
            return c / 1000000L;
        }

        @Override
        public long convert(long c, DecimalByteUnit u) {
            return u.toTerabytes(c);
        }
    }
    ,
    PETABYTES{

        @Override
        public long toBytes(long c) {
            return DecimalByteUnit.x(c, 1000000000000000L, 9223L);
        }

        @Override
        public long toKilobytes(long c) {
            return DecimalByteUnit.x(c, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toMegabytes(long c) {
            return DecimalByteUnit.x(c, 1000000000L, 9223372036L);
        }

        @Override
        public long toGigabytes(long c) {
            return DecimalByteUnit.x(c, 1000000L, 9223372036854L);
        }

        @Override
        public long toTerabytes(long c) {
            return DecimalByteUnit.x(c, 1000L, 9223372036854775L);
        }

        @Override
        public long toPetabytes(long c) {
            return c;
        }

        @Override
        public long toExabytes(long c) {
            return c / 1000L;
        }

        @Override
        public long convert(long c, DecimalByteUnit u) {
            return u.toPetabytes(c);
        }
    }
    ,
    EXABYTES{

        @Override
        public long toBytes(long c) {
            return DecimalByteUnit.x(c, 1000000000000000000L, 9L);
        }

        @Override
        public long toKilobytes(long c) {
            return DecimalByteUnit.x(c, 1000000000000000L, 9223L);
        }

        @Override
        public long toMegabytes(long c) {
            return DecimalByteUnit.x(c, 1000000000000L, 0x8CBCCCL);
        }

        @Override
        public long toGigabytes(long c) {
            return DecimalByteUnit.x(c, 1000000000L, 9223372036L);
        }

        @Override
        public long toTerabytes(long c) {
            return DecimalByteUnit.x(c, 1000000L, 9223372036854L);
        }

        @Override
        public long toPetabytes(long c) {
            return DecimalByteUnit.x(c, 1000L, 9223372036854775L);
        }

        @Override
        public long toExabytes(long c) {
            return c;
        }

        @Override
        public long convert(long c, DecimalByteUnit u) {
            return u.toExabytes(c);
        }
    };

    private static final long C0 = 1L;
    private static final long C1 = 1000L;
    private static final long C2 = 1000000L;
    private static final long C3 = 1000000000L;
    private static final long C4 = 1000000000000L;
    private static final long C5 = 1000000000000000L;
    private static final long C6 = 1000000000000000000L;

    private static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public abstract long toKilobytes(long var1);

    public abstract long toMegabytes(long var1);

    public abstract long toGigabytes(long var1);

    public abstract long toTerabytes(long var1);

    public abstract long toPetabytes(long var1);

    public abstract long toExabytes(long var1);

    public abstract long convert(long var1, DecimalByteUnit var3);
}

