/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.i18n;

import com.blackducksoftware.common.io.BinaryByteUnit;
import com.blackducksoftware.common.io.ByteUnit;
import com.blackducksoftware.common.io.DecimalByteUnit;
import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Objects;

public class BinaryPrefixFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public static final int NUMBER_FIELD = 0;
    public static final int PREFIX_FIELD = 1;
    private final Style style;
    private final NumberFormat numberFormat;

    public static BinaryPrefixFormat getInstance() {
        return BinaryPrefixFormat.getInstance(DecimalFormat.getNumberInstance());
    }

    public static BinaryPrefixFormat getInstance(NumberFormat numberFormat) {
        return BinaryPrefixFormat.getInstance(Style.SHORT, numberFormat);
    }

    public static BinaryPrefixFormat getInstance(Style style, NumberFormat numberFormat) {
        return new BinaryPrefixFormat(style, numberFormat);
    }

    public static BinaryPrefixFormat getBinaryInstance() {
        return BinaryPrefixFormat.getBinaryInstance(DecimalFormat.getNumberInstance());
    }

    public static BinaryPrefixFormat getBinaryInstance(NumberFormat numberFormat) {
        return BinaryPrefixFormat.getBinaryInstance(Style.SHORT, numberFormat);
    }

    public static BinaryPrefixFormat getBinaryInstance(Style style, NumberFormat numberFormat) {
        return new BinaryBinaryPrefixFormat(style, numberFormat);
    }

    public static BinaryPrefixFormat getDecimalInstance() {
        return BinaryPrefixFormat.getDecimalInstance(DecimalFormat.getNumberInstance());
    }

    public static BinaryPrefixFormat getDecimalInstance(NumberFormat numberFormat) {
        return new DecimalBinaryPrefixFormat(Style.SHORT, numberFormat);
    }

    public static BinaryPrefixFormat getDecimalInstance(Style style, NumberFormat numberFormat) {
        return new DecimalBinaryPrefixFormat(style, numberFormat);
    }

    protected BinaryPrefixFormat(Style style, NumberFormat numberFormat) {
        this.style = Objects.requireNonNull(style);
        this.numberFormat = Objects.requireNonNull(numberFormat);
    }

    public String format(long count, ByteUnit unit) {
        return this.format(unit.toBytes(count), new StringBuffer(), new FieldPosition(0)).toString();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Preconditions.checkArgument((boolean)(obj instanceof Number), (Object)"Cannot format the give object as a byte count");
        Number number = (Number)obj;
        ByteUnit unit = this.chooseUnit(number.longValue());
        double value = number.doubleValue() / (double)DefaultByteUnit.BYTES.convert(1L, unit);
        return this.numberFormat.format(value, toAppendTo, pos).append(' ').append(this.abbreviate(unit, this.style));
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    protected ByteUnit chooseUnit(long count) {
        return DefaultByteUnit.BYTES;
    }

    protected String abbreviate(ByteUnit unit, Style style) {
        if (unit == DefaultByteUnit.BYTES && style == Style.SHORT) {
            return "B";
        }
        if (style == Style.LONG) {
            return unit.toString().toLowerCase();
        }
        throw new UnsupportedOperationException("unable to abbreviate the unit " + unit + " using the style " + (Object)((Object)style));
    }

    private static class DecimalBinaryPrefixFormat
    extends BinaryPrefixFormat {
        private static final long serialVersionUID = 1L;
        private static final String[] ABBREVIATIONS = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};

        protected DecimalBinaryPrefixFormat(Style style, NumberFormat numberFormat) {
            super(style, numberFormat);
        }

        @Override
        protected DecimalByteUnit chooseUnit(long count) {
            if (DecimalByteUnit.BYTES.toExabytes(count) > 0L) {
                return DecimalByteUnit.EXABYTES;
            }
            if (DecimalByteUnit.BYTES.toPetabytes(count) > 0L) {
                return DecimalByteUnit.PETABYTES;
            }
            if (DecimalByteUnit.BYTES.toTerabytes(count) > 0L) {
                return DecimalByteUnit.TERABYTES;
            }
            if (DecimalByteUnit.BYTES.toGigabytes(count) > 0L) {
                return DecimalByteUnit.GIGABYTES;
            }
            if (DecimalByteUnit.BYTES.toMegabytes(count) > 0L) {
                return DecimalByteUnit.MEGABYTES;
            }
            if (DecimalByteUnit.BYTES.toKilobytes(count) > 0L) {
                return DecimalByteUnit.KILOBYTES;
            }
            return DecimalByteUnit.BYTES;
        }

        @Override
        protected String abbreviate(ByteUnit unit, Style style) {
            if (unit instanceof DecimalByteUnit && style == Style.SHORT) {
                return ABBREVIATIONS[((DecimalByteUnit)unit).ordinal()];
            }
            return super.abbreviate(unit, style);
        }
    }

    private static class BinaryBinaryPrefixFormat
    extends BinaryPrefixFormat {
        private static final long serialVersionUID = 1L;
        private static final String[] ABBREVIATIONS = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};

        protected BinaryBinaryPrefixFormat(Style style, NumberFormat numberFormat) {
            super(style, numberFormat);
        }

        @Override
        protected BinaryByteUnit chooseUnit(long count) {
            if (BinaryByteUnit.BYTES.toExbibytes(count) > 0L) {
                return BinaryByteUnit.EXBIBYTES;
            }
            if (BinaryByteUnit.BYTES.toPebibytes(count) > 0L) {
                return BinaryByteUnit.PEBIBYTES;
            }
            if (BinaryByteUnit.BYTES.toTebibytes(count) > 0L) {
                return BinaryByteUnit.TEBIBYTES;
            }
            if (BinaryByteUnit.BYTES.toGibibytes(count) > 0L) {
                return BinaryByteUnit.GIBIBYTES;
            }
            if (BinaryByteUnit.BYTES.toMebibytes(count) > 0L) {
                return BinaryByteUnit.MEBIBYTES;
            }
            if (BinaryByteUnit.BYTES.toKibibytes(count) > 0L) {
                return BinaryByteUnit.KIBIBYTES;
            }
            return BinaryByteUnit.BYTES;
        }

        @Override
        protected String abbreviate(ByteUnit unit, Style style) {
            if (unit instanceof BinaryByteUnit && style == Style.SHORT) {
                return ABBREVIATIONS[((BinaryByteUnit)unit).ordinal()];
            }
            return super.abbreviate(unit, style);
        }
    }

    private static enum DefaultByteUnit implements ByteUnit
    {
        BYTES{

            @Override
            public long toBytes(long count) {
                return count;
            }

            @Override
            public long convert(long sourceCount, ByteUnit sourceUnit) {
                if (sourceUnit instanceof DefaultByteUnit) {
                    return ((DefaultByteUnit)sourceUnit).toBytes(sourceCount);
                }
                if (sourceUnit instanceof BinaryByteUnit) {
                    return ((BinaryByteUnit)sourceUnit).toBytes(sourceCount);
                }
                if (sourceUnit instanceof DecimalByteUnit) {
                    return ((DecimalByteUnit)sourceUnit).toBytes(sourceCount);
                }
                throw new IllegalArgumentException("unknown byte unit: " + sourceUnit);
            }
        };


        public abstract long convert(long var1, ByteUnit var3);
    }

    public static enum Style {
        SHORT,
        LONG;

    }
}

