/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class ExtraStreams {
    public static <T> Function<Object, Stream<T>> ofType(Class<T> type) {
        Objects.requireNonNull(type);
        return obj -> type.isInstance(obj) ? Stream.of(type.cast(obj)) : Stream.empty();
    }

    public static <T, R> Function<T, Stream<R>> fromOptional(Function<T, Optional<R>> function) {
        Objects.requireNonNull(function);
        return t -> Streams.stream((Optional)((Optional)function.apply(t)));
    }

    public static <T> Stream<T> stream(Enumeration<T> enumeration) {
        return Streams.stream((Iterator)Iterators.forEnumeration(enumeration));
    }

    public static <E extends Enum<E>> Stream<E> stream(Class<E> enumClass) {
        return Arrays.stream((Enum[])enumClass.getEnumConstants());
    }

    public static <T> Stream<T> streamNullable(@Nullable Iterable<T> iterable) {
        return iterable != null ? Streams.stream(iterable) : Stream.empty();
    }

    public static <T> Stream<T> of(@Nullable T first, T[] rest) {
        return rest.length != 0 ? Stream.concat(Stream.of(first), Arrays.stream(rest)) : Stream.of(first);
    }

    public static <T> Stream<T> of(@Nullable T first, @Nullable T second, T[] rest) {
        return rest.length != 0 ? Stream.concat(Stream.of(first, second), Arrays.stream(rest)) : Stream.of(first, second);
    }

    public static <T> Stream<T> ofNullable(@Nullable T t) {
        return t != null ? Stream.of(t) : Stream.empty();
    }

    private ExtraStreams() {
        assert (false);
    }
}

