/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import com.blackducksoftware.common.annotations.Obsolete;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class ExtraOptionals {
    @Obsolete(value="Added in Java 9", see="java.util.Optional#ifPresentOrElse")
    public static <T> void ifPresentOrElse(Optional<T> self, Consumer<? super T> action, Runnable emptyAction) {
        Object value = self.orElse(null);
        if (value != null) {
            action.accept(value);
        } else {
            emptyAction.run();
        }
    }

    @Obsolete(value="Added in Java 9", see="java.util.Optional#or")
    public static <T> Optional<T> or(Optional<T> self, Supplier<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (self.isPresent()) {
            return self;
        }
        Optional<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public static <T> Optional<T> mapToObj(OptionalDouble self, DoubleFunction<? extends T> mapper) {
        Objects.requireNonNull(mapper);
        if (self.isPresent()) {
            return Optional.ofNullable(mapper.apply(self.getAsDouble()));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> mapToObj(OptionalInt self, IntFunction<? extends T> mapper) {
        Objects.requireNonNull(mapper);
        if (self.isPresent()) {
            return Optional.ofNullable(mapper.apply(self.getAsInt()));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> mapToObj(OptionalLong self, LongFunction<? extends T> mapper) {
        Objects.requireNonNull(mapper);
        if (self.isPresent()) {
            return Optional.ofNullable(mapper.apply(self.getAsLong()));
        }
        return Optional.empty();
    }

    @Deprecated
    public static <T> Function<Object, Optional<T>> ofType(Class<T> type) {
        Objects.requireNonNull(type);
        return obj -> type.isInstance(obj) ? Optional.of(type.cast(obj)) : Optional.empty();
    }

    public static <T> Predicate<Optional<T>> isOptionalEqual(@Nullable T target) {
        return target != null ? o -> o.isPresent() && o.get().equals(target) : ExtraOptionals.isEmpty();
    }

    public static <T> Predicate<Optional<T>> isEmpty() {
        return o -> !o.isPresent();
    }

    public static <A, B> void ifPresent(Optional<A> a, Optional<B> b, BiConsumer<? super A, ? super B> consumer) {
        Objects.requireNonNull(consumer);
        Objects.requireNonNull(b);
        if (a.isPresent() && b.isPresent()) {
            consumer.accept(a.get(), b.get());
        }
    }

    public static <A, B, C> Optional<C> map(Optional<A> a, Optional<B> b, BiFunction<? super A, ? super B, ? extends C> mapper) {
        Objects.requireNonNull(mapper);
        Objects.requireNonNull(b);
        if (a.isPresent() && b.isPresent()) {
            return Optional.ofNullable(mapper.apply(a.get(), b.get()));
        }
        return Optional.empty();
    }

    public static <T> Optional<T> merge(Optional<T> a, Optional<T> b, BinaryOperator<T> combiner) {
        Objects.requireNonNull(combiner);
        Objects.requireNonNull(b);
        if (a.isPresent() && b.isPresent()) {
            return combiner.andThen(Optional::ofNullable).apply(a.get(), b.get());
        }
        return a.isPresent() ? a : b;
    }

    public static <T, U> Optional<U> flatMapThrowable(Optional<T> self, Function<? super T, U> mapper) {
        try {
            return self.map(mapper);
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public static <T, R> Stream<R> flatMapMany(Optional<T> self, Function<? super T, ? extends Stream<? extends R>> mapper) {
        return (self.isPresent() ? Stream.of(self.get()) : Stream.empty()).flatMap(mapper);
    }

    private ExtraOptionals() {
        assert (false);
    }
}

