/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import com.blackducksoftware.common.base.ExtraStrings;
import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.google.common.collect.MoreCollectors;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class ExtraEnums {
    public static <E extends Enum<E>> EnumSearcher<E> search(Class<E> enumType) {
        return new EnumSearcher((Class)enumType);
    }

    public static <E extends Enum<E>> Optional<E> tryByName(Class<E> enumClass, String name) {
        return Enums.getIfPresent(enumClass, (String)name).toJavaUtil();
    }

    public static <E extends Enum<E>> Stream<E> tryByToString(Class<E> enumClass, String toStringValue) {
        return ExtraEnums.search(enumClass).withToString(toStringValue);
    }

    public static <E extends Enum<E>> Optional<E> previous(E enumValue) {
        if (enumValue.ordinal() > 0) {
            return Optional.of(((Enum[])enumValue.getDeclaringClass().getEnumConstants())[enumValue.ordinal() - 1]);
        }
        return Optional.empty();
    }

    public static <E extends Enum<E>> Optional<E> next(E enumValue) {
        Enum[] enumConstants = (Enum[])enumValue.getDeclaringClass().getEnumConstants();
        if (enumValue.ordinal() + 1 < enumConstants.length) {
            return Optional.of(enumConstants[enumValue.ordinal() + 1]);
        }
        return Optional.empty();
    }

    public static <E extends Enum<E>> boolean set(Set<E> set, E value, boolean on) {
        Objects.requireNonNull(value);
        return on ? set.add(value) : set.remove(value);
    }

    public static <E extends Enum<E>> void flip(Set<E> set, E value) {
        Objects.requireNonNull(value);
        if (set.contains(value)) {
            set.remove(value);
        } else {
            set.add(value);
        }
    }

    @Beta
    public static <E extends Enum<E>> EnumSet<E> fromBitSet(Class<E> enumClass, long bitSet) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkArgument(((bitSet & Long.MAX_VALUE) >>> enumConstants.length == 0L ? 1 : 0) != 0, (String)"bit set overflows enum: %s", (Object)enumClass.getName());
        EnumSet<Enum> result = EnumSet.noneOf(enumClass);
        for (Enum value : enumConstants) {
            if ((bitSet & 1L << value.ordinal()) == 0L) continue;
            result.add(value);
        }
        return result;
    }

    @Beta
    public static <E extends Enum<E>> EnumSet<E> fromBitSet(Class<E> enumClass, BitSet bitSet) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkArgument((bitSet.length() <= enumConstants.length ? 1 : 0) != 0, (String)"bit set overflows enum: %s", (Object)enumClass.getName());
        EnumSet<Enum> result = EnumSet.noneOf(enumClass);
        for (Enum value : enumConstants) {
            if (!bitSet.get(value.ordinal())) continue;
            result.add(value);
        }
        return result;
    }

    @Beta
    public static <E extends Enum<E>> int toBitSet(Set<E> values) {
        int result = 0;
        for (Enum value : values) {
            result &= 1 << value.ordinal();
        }
        return result;
    }

    private ExtraEnums() {
        assert (false);
    }

    public static class EnumSearcher<E extends Enum<E>> {
        private final boolean start;
        private final Class<E> enumType;
        private final BiPredicate<String, String> filter;

        private EnumSearcher(Class<E> enumType) {
            this.start = true;
            this.enumType = Objects.requireNonNull(enumType);
            this.filter = Objects::equals;
        }

        private EnumSearcher(Class<E> enumType, BiPredicate<String, String> filter) {
            this.start = false;
            this.enumType = Objects.requireNonNull(enumType);
            this.filter = Objects.requireNonNull(filter);
        }

        private EnumSearcher(EnumSearcher<E> searcher, Function<String, String> mapper) {
            this(searcher.enumType, (String a, String b) -> searcher.filter.test((String)mapper.apply((String)a), (String)mapper.apply((String)b)));
        }

        public Optional<E> byName(String name) {
            if (this.start) {
                return Enums.getIfPresent(this.enumType, (String)name).toJavaUtil();
            }
            return (Optional)this.withName(name).collect(MoreCollectors.toOptional());
        }

        public Optional<E> byToString(String value) {
            return (Optional)this.withToString(value).collect(MoreCollectors.toOptional());
        }

        public Stream<E> withName(String name) {
            Objects.requireNonNull(name);
            return Arrays.stream((Enum[])this.enumType.getEnumConstants()).filter(e -> this.filter.test(e.name(), name));
        }

        public Stream<E> withToString(String value) {
            Objects.requireNonNull(value);
            return Arrays.stream((Enum[])this.enumType.getEnumConstants()).filter(e -> this.filter.test(e.toString(), value));
        }

        public EnumSearcher<E> ignoringCase() {
            return new EnumSearcher<E>(this, String::toLowerCase);
        }

        public EnumSearcher<E> ignoring(CharSequence chars) {
            return new EnumSearcher<E>(this, arg_0 -> ((CharMatcher)CharMatcher.anyOf((CharSequence)chars)).removeFrom(arg_0));
        }

        public EnumSearcher<E> ignoring(Predicate<? super Character> chars) {
            return new EnumSearcher<E>(this, arg_0 -> ((CharMatcher)CharMatcher.forPredicate(chars::test)).removeFrom(arg_0));
        }

        public EnumSearcher<E> usingLowerCamel() {
            return new EnumSearcher<E>(this.enumType, (a, b) -> this.filter.test(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, a), (String)b));
        }

        public EnumSearcher<E> startsWith(String prefix) {
            return new EnumSearcher<E>(this, s -> ExtraStrings.removePrefix(s, prefix));
        }
    }
}

