/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.common.base;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ExtraCollectors {
    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, ExtraCollectors.throwingMerger(), mapSupplier);
    }

    public static <T, K> Collector<T, ?, Map<K, T>> index(Function<? super T, ? extends K> keyMapper) {
        return Collectors.toMap(keyMapper, Function.identity());
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMapOfEntries() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <E extends Enum<E>> Collector<E, ?, Set<String>> enumNames() {
        return Collectors.mapping(Enum::name, Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public static <E extends Enum<E>> Collector<E, ?, List<String>> enumStrings() {
        return Collectors.mapping(Enum::toString, Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static <E extends Enum<E>> Collector<E, ?, Set<String>> uniqueEnumStrings() {
        return Collectors.mapping(Enum::toString, Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private ExtraCollectors() {
        assert (false);
    }
}

