/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.api.core;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.core.ResourceLink;
import com.blackduck.integration.blackduck.api.core.ResourceMetadata;
import com.blackduck.integration.blackduck.api.core.response.LinkMultipleResponses;
import com.blackduck.integration.blackduck.api.core.response.LinkSingleResponse;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.rest.HttpUrl;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;

public class BlackDuckView
extends BlackDuckResponse {
    private ResourceMetadata _meta;

    public ResourceMetadata getMeta() {
        return this._meta;
    }

    public void setMeta(ResourceMetadata meta) {
        this._meta = meta;
    }

    public boolean hasLink(String linkKey) {
        if (null == this._meta || null == this._meta.getLinks()) {
            return false;
        }
        return this._meta.getLinks().stream().map(ResourceLink::getRel).anyMatch(linkKey::equals);
    }

    public <T extends BlackDuckResponse> UrlSingleResponse<T> metaSingleResponse(LinkSingleResponse<T> linkSingleResponse) {
        HttpUrl url = this.getFirstLink(linkSingleResponse.getLink());
        return new UrlSingleResponse(url, linkSingleResponse.getResponseClass());
    }

    public <T extends BlackDuckResponse> UrlMultipleResponses<T> metaMultipleResponses(LinkMultipleResponses<T> linkMultipleResponses) {
        HttpUrl url = this.getFirstLink(linkMultipleResponses.getLink());
        return new UrlMultipleResponses(url, linkMultipleResponses.getResponseClass());
    }

    public HttpUrl getFirstLink(String linkKey) {
        return this.getFirstLinkSafely(linkKey).orElseThrow(() -> new NoSuchElementException(String.format("The link key %s was not found.", linkKey)));
    }

    public <T extends BlackDuckResponse> Optional<UrlSingleResponse<T>> metaSingleResponseSafely(LinkSingleResponse<T> linkSingleResponse) {
        return this.getFirstLinkSafely(linkSingleResponse.getLink()).map(url -> new UrlSingleResponse((HttpUrl)url, linkSingleResponse.getResponseClass()));
    }

    public <T extends BlackDuckResponse> Optional<UrlMultipleResponses<T>> metaMultipleResponsesSafely(LinkMultipleResponses<T> linkMultipleResponses) {
        return this.getFirstLinkSafely(linkMultipleResponses.getLink()).map(url -> new UrlMultipleResponses((HttpUrl)url, linkMultipleResponses.getResponseClass()));
    }

    public Optional<HttpUrl> getFirstLinkSafely(String linkKey) {
        return this._meta.getLinks().stream().filter(resourceLink -> resourceLink.getRel().equals(linkKey)).findFirst().map(ResourceLink::getHref);
    }

    public List<HttpUrl> getLinks(String linkKey) {
        return this.getResourceLinks().stream().filter(resourceLink -> resourceLink.getRel().equals(linkKey)).map(ResourceLink::getHref).collect(Collectors.toList());
    }

    public ResourceMetadata getResourceMetadata() {
        return this._meta;
    }

    public List<ResourceLink> getResourceLinks() {
        if (null == this._meta || null == this._meta.getLinks()) {
            return Collections.emptyList();
        }
        return this._meta.getLinks();
    }

    public List<String> getAvailableLinks() {
        return this.getResourceLinks().stream().map(ResourceLink::getRel).collect(Collectors.toList());
    }

    public List<String> getAllowedMethods() {
        if (null == this._meta || null == this._meta.getAllow()) {
            return Collections.emptyList();
        }
        return this._meta.getAllow();
    }

    public HttpUrl getHref() {
        return this._meta.getHref();
    }

    public String getMediaType() {
        return ContentType.APPLICATION_JSON.getMimeType();
    }
}

