/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.api.core;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.HttpUrl;

public class BlackDuckPath<T extends BlackDuckResponse> {
    private final String path;
    private final Class<T> responseClass;
    private final boolean isMultiple;

    public static <T extends BlackDuckResponse> BlackDuckPath<T> single(String path, Class<T> responseClass) {
        return new BlackDuckPath<T>(path, responseClass, false);
    }

    public static <T extends BlackDuckResponse> BlackDuckPath<T> multiple(String path, Class<T> responseClass) {
        return new BlackDuckPath<T>(path, responseClass, true);
    }

    public BlackDuckPath(String path, Class<T> responseClass, boolean isMultiple) {
        this.path = path;
        this.responseClass = responseClass;
        this.isMultiple = isMultiple;
    }

    public String getPath() {
        return this.path;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public HttpUrl getFullBlackDuckUrl(HttpUrl blackDuckUrl) {
        try {
            return blackDuckUrl.appendRelativeUrl(this.path);
        }
        catch (IntegrationException e) {
            throw new IllegalArgumentException(String.format("The supplied path: %s could not be appended to the Black Duck url: %s", blackDuckUrl.string(), this.path), e);
        }
    }

    public String toString() {
        return this.path;
    }
}

