/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.wait;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.wait.ResilientJob;
import com.blackduck.integration.wait.ResilientJobConfig;
import java.time.Duration;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ResilientJobExecutor {
    protected final ResilientJobConfig jobConfig;

    public ResilientJobExecutor(ResilientJobConfig jobConfig) {
        this.jobConfig = jobConfig;
    }

    public <T> T executeJob(ResilientJob<T> resilientJob) throws InterruptedException, IntegrationException {
        int attempts = 1;
        IntLogger intLogger = this.jobConfig.getIntLogger();
        long startTime = this.jobConfig.getStartTime();
        Duration currentDuration = Duration.ZERO;
        Duration maximumDuration = Duration.ofMillis(this.jobConfig.getTimeoutInSeconds() * 1000L);
        String taskDescription = String.format("for task %s ", resilientJob.getName());
        do {
            String attemptPrefix = String.format("Try #%s %s(elapsed: %s)...", attempts, taskDescription, DurationFormatUtils.formatDurationHMS((long)currentDuration.toMillis()));
            resilientJob.attemptJob();
            if (resilientJob.wasJobCompleted()) {
                intLogger.info(String.format("%scomplete!", attemptPrefix));
                return resilientJob.onCompletion();
            }
            long waitTimeInSeconds = this.jobConfig.getWaitIntervalInSeconds();
            intLogger.info(String.format("%snot done yet, waiting %s seconds and trying again...", attemptPrefix, waitTimeInSeconds));
            Thread.sleep(waitTimeInSeconds * 1000L);
            currentDuration = Duration.ofMillis(System.currentTimeMillis() - startTime);
            ++attempts;
        } while (currentDuration.compareTo(maximumDuration) <= 0);
        return resilientJob.onTimeout();
    }
}

