/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.util;

import com.blackduck.integration.util.TokenizerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExcludedIncludedFilter {
    public static final ExcludedIncludedFilter EMPTY = new ExcludedIncludedFilter(Collections.emptyList(), Collections.emptyList());
    protected final Set<String> excludedSet;
    protected final Set<String> includedSet;
    protected final boolean lenient;

    public static ExcludedIncludedFilter fromCommaSeparatedStrings(String toExclude, String toInclude) {
        return new ExcludedIncludedFilter(TokenizerUtils.createSetFromString(toExclude), TokenizerUtils.createSetFromString(toInclude));
    }

    public ExcludedIncludedFilter(Collection<String> toExcludeList, Collection<String> toIncludeList) {
        this(toExcludeList, toIncludeList, true);
    }

    public ExcludedIncludedFilter(Collection<String> toExcludeList, Collection<String> toIncludeList, boolean lenient) {
        this.excludedSet = new HashSet<String>(toExcludeList);
        this.includedSet = new HashSet<String>(toIncludeList);
        this.lenient = lenient;
    }

    public boolean willExclude(String itemName) {
        return this.excludedSet.contains(itemName);
    }

    public boolean willInclude(String itemName) {
        if (this.includedSet.isEmpty()) {
            return this.lenient;
        }
        return this.includedSet.contains(itemName);
    }

    public final boolean shouldInclude(String itemName) {
        if (this.willExclude(itemName)) {
            return false;
        }
        return this.willInclude(itemName);
    }
}

