/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.util;

import com.blackduck.integration.util.ExcludedIncludedFilter;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcludedIncludedAllNoneFilter
extends ExcludedIncludedFilter {
    public static final String ALL = "ALL";
    public static final String NONE = "NONE";
    private final boolean allNoneSpecified;
    private final boolean excludeAll;

    public ExcludedIncludedAllNoneFilter(Collection<String> toExcludeList, Collection<String> toIncludeList, boolean lenient) {
        super(toExcludeList, toIncludeList, lenient);
        Set<String> excludingAllOrNone = this.reduceToAllOrNone(toExcludeList);
        Set<String> includingAllOrNone = this.reduceToAllOrNone(toIncludeList);
        if (excludingAllOrNone.contains(ALL) || includingAllOrNone.contains(NONE)) {
            this.allNoneSpecified = true;
            this.excludeAll = true;
        } else if (excludingAllOrNone.contains(NONE) || includingAllOrNone.contains(ALL)) {
            this.allNoneSpecified = true;
            this.excludeAll = false;
        } else {
            this.allNoneSpecified = false;
            this.excludeAll = false;
        }
    }

    public ExcludedIncludedAllNoneFilter(Collection<String> toExcludeList, Collection<String> toIncludeList) {
        this(toExcludeList, toIncludeList, true);
    }

    private Set<String> reduceToAllOrNone(Collection<String> list) {
        return list.stream().filter(s -> ALL.equalsIgnoreCase((String)s) || NONE.equalsIgnoreCase((String)s)).collect(Collectors.toSet());
    }

    @Override
    public boolean willExclude(String itemName) {
        if (this.allNoneSpecified) {
            return this.excludeAll;
        }
        return super.willExclude(itemName);
    }

    @Override
    public boolean willInclude(String itemName) {
        if (this.allNoneSpecified) {
            return !this.excludeAll;
        }
        return super.willInclude(itemName);
    }
}

