/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.util;

import com.blackduck.integration.util.TokenizerUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class EnumUtils {
    public static String prettyPrint(Enum<?> enumValue) {
        String name = enumValue.name();
        String prettyName = WordUtils.capitalizeFully((String)name.replace("_", " "));
        return prettyName;
    }

    public static <T extends Enum<T>> List<T> parseCommaDelimitted(String commaDelimittedEnumString, Class<T> enumClass) {
        return TokenizerUtils.createListFromString(commaDelimittedEnumString).stream().filter(StringUtils::isNotBlank).map(token -> Enum.valueOf(enumClass, token)).collect(Collectors.toList());
    }

    public static <T extends Enum<T>> List<T> convert(Collection<String> values, Class<T> enumClass) {
        return values.stream().map(String::trim).filter(StringUtils::isNotBlank).map(token -> Enum.valueOf(enumClass, token)).collect(Collectors.toList());
    }
}

