/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.util;

import com.blackduck.integration.util.EnumUtils;
import com.blackduck.integration.util.ExcludedIncludedAllNoneFilter;
import com.blackduck.integration.util.ExcludedIncludedFilter;
import com.blackduck.integration.util.TokenizerUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumSetFactory<E extends Enum<E>> {
    private final Class<E> enumClass;

    public EnumSetFactory(Class<E> enumClass) {
        this.enumClass = enumClass;
        Set names = EnumSet.allOf(enumClass).stream().map(Enum::name).map(String::toUpperCase).collect(Collectors.toSet());
        if (names.contains("ALL") || names.contains("NONE")) {
            throw new IllegalArgumentException("EnumSetFactory can not support an enum with 'all' or 'none' as values.");
        }
    }

    public EnumSet<E> parseIncludedValues(String enumValues) {
        Set<String> valuesToInclude = TokenizerUtils.createSetFromString(enumValues);
        if (valuesToInclude.isEmpty()) {
            return EnumSet.noneOf(this.enumClass);
        }
        ExcludedIncludedAllNoneFilter filter = new ExcludedIncludedAllNoneFilter(Collections.emptySet(), valuesToInclude, false);
        return this.parse(filter);
    }

    public EnumSet<E> parse(ExcludedIncludedFilter excludedIncludedFilter) {
        Set<String> namesToInclude = EnumSet.allOf(this.enumClass).stream().map(Enum::name).filter(excludedIncludedFilter::shouldInclude).collect(Collectors.toSet());
        if (namesToInclude.isEmpty()) {
            return EnumSet.noneOf(this.enumClass);
        }
        return EnumSet.copyOf(EnumUtils.convert(namesToInclude, this.enumClass));
    }
}

