/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.util;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.util.CommonZipExpander;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;

public class CleanupZipExpander
extends CommonZipExpander {
    private final boolean alsoDeleteFiles;

    public CleanupZipExpander(IntLogger logger) {
        this(logger, false);
    }

    public CleanupZipExpander(IntLogger logger, boolean alsoDeleteFiles) {
        super(logger);
        this.alsoDeleteFiles = alsoDeleteFiles;
    }

    @Override
    public void beforeExpansion(File sourceArchiveFile, File targetExpansionDirectory) throws IntegrationException {
        File[] toDelete = targetExpansionDirectory.listFiles(file -> file.isDirectory() || this.alsoDeleteFiles);
        if (toDelete != null && toDelete.length > 0) {
            this.logger.warn(String.format("There were items in %s that are being deleted. This may happen under normal conditions, but please do not place items in the expansion directory as this directory is assumed to be under the integration's control.", targetExpansionDirectory.getAbsolutePath()));
            Arrays.stream(toDelete).forEach(FileUtils::deleteQuietly);
        }
    }
}

