/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.properties;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.properties.PropertiesManager;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.junit.jupiter.api.Assumptions;

public class TestPropertiesManager
extends PropertiesManager {
    public static final String DEFAULT_TEST_PROPERTIES_FILE_NAME = "test.properties";
    public static final String DEFAULT_TEST_PROPERTIES_LOCATION = "src/main/resources/test.properties";

    public static TestPropertiesManager loadProperties(Properties properties) {
        return new TestPropertiesManager(properties);
    }

    public static TestPropertiesManager loadFromDefaultFile() {
        return TestPropertiesManager.loadWithOverrides(DEFAULT_TEST_PROPERTIES_LOCATION, Collections.emptyMap());
    }

    public static TestPropertiesManager loadFromEnvironmentAndDefaultFile(Map<String, String> environmentProperties) {
        return TestPropertiesManager.loadWithOverrides(DEFAULT_TEST_PROPERTIES_LOCATION, environmentProperties);
    }

    public static TestPropertiesManager loadFromFile(String propertiesFileLocation) {
        return TestPropertiesManager.loadWithOverrides(propertiesFileLocation, null);
    }

    public static TestPropertiesManager loadFromEnvironment(Map<String, String> environmentProperties) {
        TestPropertiesManager testPropertiesManager = new TestPropertiesManager();
        testPropertiesManager.addPropertiesFromEnv(environmentProperties);
        return testPropertiesManager;
    }

    public static TestPropertiesManager loadWithOverrides(String propertiesFileLocation, Map<String, String> environmentProperties) {
        TestPropertiesManager testPropertiesManager = new TestPropertiesManager();
        testPropertiesManager.addProperties(propertiesFileLocation, environmentProperties);
        return testPropertiesManager;
    }

    private TestPropertiesManager() {
    }

    private TestPropertiesManager(Properties properties) {
        super(properties);
    }

    @Override
    protected void addProperties(String propertiesFileLocation, Map<String, String> environmentProperties) {
        try {
            super.validatePropertiesLocation(propertiesFileLocation);
            super.addPropertiesFromFile(propertiesFileLocation);
        }
        catch (IntegrationException | IOException e) {
            System.out.println("Failed to load properties from " + propertiesFileLocation);
            System.out.println(e.getMessage());
        }
        super.addPropertiesFromEnv(environmentProperties);
    }

    @Override
    public Optional<String> getProperty(String propertyKey) {
        Assumptions.assumeTrue((boolean)this.containsKey(propertyKey));
        return super.getProperty(propertyKey);
    }

    public String getRequiredProperty(String propertyKey) throws IntegrationException {
        return super.getProperty(propertyKey).orElseThrow(() -> new IntegrationException("Required property does not exist: " + propertyKey));
    }
}

