/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.properties;

import com.blackduck.integration.exception.IntegrationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class PropertiesManager {
    private final Properties properties = new Properties();

    public static PropertiesManager loadProperties(Properties properties) {
        return new PropertiesManager(properties);
    }

    public static PropertiesManager loadFromFile(String propertiesFileLocation) throws IOException, IntegrationException {
        return PropertiesManager.loadWithOverrides(propertiesFileLocation, null);
    }

    public static PropertiesManager loadFromEnvironment(Map<String, String> environmentProperties) {
        PropertiesManager propertiesManager = new PropertiesManager();
        propertiesManager.addPropertiesFromEnv(environmentProperties);
        return propertiesManager;
    }

    public static PropertiesManager loadWithOverrides(String propertiesFileLocation, Map<String, String> environmentProperties) throws IOException, IntegrationException {
        PropertiesManager propertiesManager = new PropertiesManager();
        propertiesManager.addProperties(propertiesFileLocation, environmentProperties);
        return propertiesManager;
    }

    protected PropertiesManager() {
    }

    protected PropertiesManager(Properties properties) {
        this.addProperties(properties);
    }

    private void addProperties(Properties inputProperties) {
        inputProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.properties.put(k.toString(), v.toString())));
    }

    protected void addProperties(String propertiesFileLocation, Map<String, String> environmentProperties) throws IOException, IntegrationException {
        this.validatePropertiesLocation(propertiesFileLocation);
        this.addPropertiesFromFile(propertiesFileLocation);
        this.addPropertiesFromEnv(environmentProperties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Optional<String> getProperty(String propertyKey) {
        return Optional.ofNullable(this.properties.getProperty(propertyKey));
    }

    public boolean containsKey(String propertyKey) {
        return this.properties.containsKey(propertyKey);
    }

    protected void validatePropertiesLocation(String propertiesFileLocation) throws IntegrationException {
        if (StringUtils.isBlank((CharSequence)propertiesFileLocation)) {
            throw new IntegrationException("Input file name must be valid.");
        }
        File propertiesFile = new File(propertiesFileLocation);
        if (!(propertiesFile.exists() && propertiesFile.isFile() && propertiesFile.canRead())) {
            throw new IntegrationException("Input file name must be an existing file that can be read.");
        }
    }

    protected void addPropertiesFromFile(String propertiesLocation) throws IOException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(propertiesLocation, new String[0]), new OpenOption[0]);){
            this.properties.load(inputStream);
        }
    }

    protected void addPropertiesFromEnv(Map<String, String> environmentProperties) {
        if (MapUtils.isNotEmpty(environmentProperties)) {
            Map<String, String> systemEnvVars = System.getenv();
            for (String envVarName : environmentProperties.keySet()) {
                if (!systemEnvVars.containsKey(envVarName)) continue;
                this.properties.put(environmentProperties.get(envVarName), systemEnvVars.get(envVarName));
            }
        }
    }
}

