/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.log;

import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.log.LogLevel;
import org.slf4j.Logger;

public class Slf4jIntLogger
extends IntLogger {
    private final Logger logger;

    public Slf4jIntLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void alwaysLog(String txt) {
        switch (this.getLogLevel()) {
            case TRACE: {
                this.logger.trace(txt);
                break;
            }
            case DEBUG: {
                this.logger.debug(txt);
                break;
            }
            case INFO: {
                this.logger.info(txt);
                break;
            }
            case WARN: {
                this.logger.warn(txt);
                break;
            }
            default: {
                this.logger.error(txt);
            }
        }
    }

    @Override
    public void info(String txt) {
        this.logger.info(txt);
    }

    @Override
    public void error(Throwable t) {
        this.logger.error("Throwable: " + t.getMessage(), t);
    }

    @Override
    public void error(String txt, Throwable t) {
        this.logger.error(txt, t);
    }

    @Override
    public void error(String txt) {
        this.logger.error(txt);
    }

    @Override
    public void warn(String txt) {
        this.logger.warn(txt);
    }

    @Override
    public void trace(String txt) {
        this.logger.trace(txt);
    }

    @Override
    public void trace(String txt, Throwable t) {
        this.logger.trace(txt, t);
    }

    @Override
    public void debug(String txt) {
        this.logger.debug(txt);
    }

    @Override
    public void debug(String txt, Throwable t) {
        this.logger.debug(txt, t);
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
    }

    @Override
    public LogLevel getLogLevel() {
        if (this.logger.isTraceEnabled()) {
            return LogLevel.TRACE;
        }
        if (this.logger.isDebugEnabled()) {
            return LogLevel.DEBUG;
        }
        if (this.logger.isInfoEnabled()) {
            return LogLevel.INFO;
        }
        if (this.logger.isWarnEnabled()) {
            return LogLevel.WARN;
        }
        if (this.logger.isErrorEnabled()) {
            return LogLevel.ERROR;
        }
        return LogLevel.OFF;
    }
}

