/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.log;

import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.log.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BufferedIntLogger
extends IntLogger {
    private final Map<LogLevel, List<String>> outputMap = new HashMap<LogLevel, List<String>>();

    public BufferedIntLogger() {
        this.outputMap.put(LogLevel.OFF, new ArrayList());
        this.outputMap.put(LogLevel.ERROR, new ArrayList());
        this.outputMap.put(LogLevel.WARN, new ArrayList());
        this.outputMap.put(LogLevel.INFO, new ArrayList());
        this.outputMap.put(LogLevel.DEBUG, new ArrayList());
        this.outputMap.put(LogLevel.TRACE, new ArrayList());
    }

    public void resetLogs(LogLevel level) {
        this.outputMap.put(level, new ArrayList());
    }

    public void resetAllLogs() {
        EnumSet.allOf(LogLevel.class).forEach(this::resetLogs);
    }

    public List<String> getOutputList(LogLevel level) {
        return this.outputMap.get((Object)level);
    }

    public String getOutputString(LogLevel level) {
        return StringUtils.trimToNull((String)StringUtils.join(this.getOutputList(level), (char)'\n'));
    }

    public String getErrorOutputString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    public void alwaysLog(String txt) {
        this.outputMap.get((Object)LogLevel.OFF).add(txt);
    }

    @Override
    public void debug(String txt) {
        this.outputMap.get((Object)LogLevel.DEBUG).add(txt);
    }

    @Override
    public void debug(String txt, Throwable e) {
        this.outputMap.get((Object)LogLevel.DEBUG).add(txt);
        this.outputMap.get((Object)LogLevel.DEBUG).add(this.getErrorOutputString(e));
    }

    @Override
    public void error(Throwable e) {
        this.outputMap.get((Object)LogLevel.ERROR).add(this.getErrorOutputString(e));
    }

    @Override
    public void error(String txt) {
        this.outputMap.get((Object)LogLevel.ERROR).add(txt);
    }

    @Override
    public void error(String txt, Throwable e) {
        this.outputMap.get((Object)LogLevel.ERROR).add(txt);
        this.outputMap.get((Object)LogLevel.ERROR).add(this.getErrorOutputString(e));
    }

    @Override
    public void info(String txt) {
        this.outputMap.get((Object)LogLevel.INFO).add(txt);
    }

    @Override
    public void trace(String txt) {
        this.outputMap.get((Object)LogLevel.TRACE).add(txt);
    }

    @Override
    public void trace(String txt, Throwable e) {
        this.outputMap.get((Object)LogLevel.TRACE).add(txt);
        this.outputMap.get((Object)LogLevel.TRACE).add(this.getErrorOutputString(e));
    }

    @Override
    public void warn(String txt) {
        this.outputMap.get((Object)LogLevel.WARN).add(txt);
    }

    @Override
    public void setLogLevel(LogLevel level) {
    }

    @Override
    public LogLevel getLogLevel() {
        return null;
    }
}

