/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.executable;

import com.blackduck.integration.executable.Executable;
import com.blackduck.integration.executable.ExecutableOutput;
import com.blackduck.integration.executable.ExecutableRunner;
import com.blackduck.integration.executable.ExecutableRunnerException;
import com.blackduck.integration.executable.ExecutableStreamThread;
import com.blackduck.integration.log.IntLogger;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;

public class ProcessBuilderRunner
implements ExecutableRunner {
    private final IntLogger logger;
    private final Consumer<String> threadOutputConsumer;
    private final Consumer<String> threadTraceConsumer;

    public ProcessBuilderRunner(IntLogger logger) {
        this.logger = logger;
        this.threadOutputConsumer = logger::info;
        this.threadTraceConsumer = logger::trace;
    }

    public ProcessBuilderRunner(IntLogger logger, Consumer<String> threadOutputConsumer, Consumer<String> threadTraceConsumer) {
        this.logger = logger;
        this.threadOutputConsumer = threadOutputConsumer;
        this.threadTraceConsumer = threadTraceConsumer;
    }

    public ExecutableOutput execute(ProcessBuilder processBuilder) throws ExecutableRunnerException {
        this.logger.info(String.format("Running process builder >%s", Executable.getMaskedCommand(processBuilder.command())));
        return this.executeProcessBuilder(processBuilder);
    }

    @Override
    public ExecutableOutput execute(Executable executable) throws ExecutableRunnerException {
        this.logger.info(String.format("Running executable >%s", executable.getExecutableDescription()));
        ProcessBuilder processBuilder = this.createProcessBuilder(executable);
        return this.executeProcessBuilder(processBuilder);
    }

    public ProcessBuilder createProcessBuilder(Executable executable) {
        ProcessBuilder processBuilder = new ProcessBuilder(executable.getCommandWithArguments());
        processBuilder.directory(executable.getWorkingDirectory());
        Map<String, String> processBuilderEnvironment = processBuilder.environment();
        for (String key : executable.getEnvironmentVariables().keySet()) {
            this.populateEnvironmentMap(processBuilderEnvironment, key, executable.getEnvironmentVariables().get(key));
        }
        return processBuilder;
    }

    private void populateEnvironmentMap(Map<String, String> environment, Object key, Object value) {
        if (key != null && value != null) {
            String keyString = key.toString();
            String valueString = value.toString();
            if (keyString != null && valueString != null) {
                environment.put(keyString, valueString);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ExecutableOutput executeProcessBuilder(ProcessBuilder processBuilder) throws ExecutableRunnerException {
        try {
            Process process = processBuilder.start();
            try (InputStream standardOutputStream = process.getInputStream();){
                ExecutableOutput executableOutput;
                block15: {
                    InputStream standardErrorStream = process.getErrorStream();
                    try {
                        ExecutableOutput output;
                        ExecutableStreamThread standardOutputThread = new ExecutableStreamThread(standardOutputStream, this.threadOutputConsumer, this.threadTraceConsumer);
                        standardOutputThread.start();
                        ExecutableStreamThread errorOutputThread = new ExecutableStreamThread(standardErrorStream, this.threadOutputConsumer, this.threadTraceConsumer);
                        errorOutputThread.start();
                        int returnCode = process.waitFor();
                        this.logger.info(String.format("Process return code: %d", returnCode));
                        standardOutputThread.join();
                        errorOutputThread.join();
                        String standardOutput = standardOutputThread.getExecutableOutput().trim();
                        String errorOutput = errorOutputThread.getExecutableOutput().trim();
                        executableOutput = output = new ExecutableOutput(returnCode, standardOutput, errorOutput);
                        if (standardErrorStream == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (standardErrorStream != null) {
                            try {
                                standardErrorStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    standardErrorStream.close();
                }
                return executableOutput;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExecutableRunnerException(e);
        }
        catch (Exception e) {
            throw new ExecutableRunnerException(e);
        }
    }
}

