/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.executable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class ExecutableStreamThread
extends Thread {
    private final BufferedReader bufferedReader;
    private final StringBuilder stringBuilder;
    private final Consumer<String> outputLoggingMethod;
    private final Consumer<String> traceLoggingMethod;
    private String executableOutput;

    public ExecutableStreamThread(InputStream executableStream, Consumer<String> outputLoggingMethod, Consumer<String> traceLoggingMethod) {
        super(Thread.currentThread().getName() + "-Executable_Stream_Thread");
        this.outputLoggingMethod = outputLoggingMethod;
        this.traceLoggingMethod = traceLoggingMethod;
        InputStreamReader reader = new InputStreamReader(executableStream, StandardCharsets.UTF_8);
        this.bufferedReader = new BufferedReader(reader);
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public void run() {
        try {
            String line;
            String separator = System.lineSeparator();
            while ((line = this.bufferedReader.readLine()) != null) {
                this.stringBuilder.append(line + separator);
                this.outputLoggingMethod.accept(line);
            }
        }
        catch (IOException e) {
            this.traceLoggingMethod.accept(e.toString());
        }
        this.executableOutput = this.stringBuilder.toString();
    }

    public String getExecutableOutput() {
        return this.executableOutput;
    }
}

