/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.executable;

import com.blackduck.integration.util.Stringable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Executable
extends Stringable {
    private final File workingDirectory;
    private final Map<String, String> environmentVariables = new HashMap<String, String>();
    private final List<String> commandWithArguments = new ArrayList<String>();

    public static Executable create(File workingDirectory, Map<String, String> environmentVariables, List<String> commandWithArguments) {
        return new Executable(workingDirectory, environmentVariables, commandWithArguments);
    }

    public static Executable create(File workingDirectory, Map<String, String> environmentVariables, String command, List<String> arguments) {
        ArrayList<String> commandWithArguments = new ArrayList<String>();
        commandWithArguments.add(command);
        commandWithArguments.addAll(arguments);
        return new Executable(workingDirectory, environmentVariables, commandWithArguments);
    }

    public static Executable create(File workingDirectory, List<String> commandWithArguments) {
        return Executable.create(workingDirectory, Collections.emptyMap(), commandWithArguments);
    }

    public static Executable create(File workingDirectory, String command, List<String> arguments) {
        return Executable.create(workingDirectory, Collections.emptyMap(), command, arguments);
    }

    public static Executable create(File workingDirectory, Map<String, String> environmentVariables, File executableFile) {
        return Executable.create(workingDirectory, environmentVariables, executableFile.getAbsolutePath(), Collections.emptyList());
    }

    public static Executable create(File workingDirectory, Map<String, String> environmentVariables, File executableFile, List<String> arguments) {
        return Executable.create(workingDirectory, environmentVariables, executableFile.getAbsolutePath(), arguments);
    }

    public static Executable create(File workingDirectory, File executableFile) {
        return Executable.create(workingDirectory, executableFile.getAbsolutePath(), Collections.emptyList());
    }

    public static Executable create(File workingDirectory, File executableFile, List<String> arguments) {
        return Executable.create(workingDirectory, executableFile.getAbsolutePath(), arguments);
    }

    public static String getMaskedCommand(List<String> commandWithArguments) {
        ArrayList<String> pieces = new ArrayList<String>();
        for (String argument : commandWithArguments) {
            if (argument.matches(".*password.*=.*")) {
                String maskedArgument = argument.substring(0, argument.indexOf(61) + 1) + "********";
                pieces.add(maskedArgument);
                continue;
            }
            pieces.add(argument);
        }
        return StringUtils.join(pieces, (char)' ');
    }

    public Executable(File workingDirectory, Map<String, String> environmentVariables, List<String> commandWithArguments) {
        this.workingDirectory = workingDirectory;
        this.environmentVariables.putAll(environmentVariables);
        this.commandWithArguments.addAll(commandWithArguments);
    }

    public String getExecutableDescription() {
        return Executable.getMaskedCommand(this.commandWithArguments);
    }

    public String getUnmaskedInsecureExecutableDescription() {
        return StringUtils.join(this.commandWithArguments, (char)' ');
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public List<String> getCommandWithArguments() {
        return this.commandWithArguments;
    }
}

