/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.datastructure;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SetMap<K, S>
extends AbstractMap<K, Set<S>> {
    private final Map<K, Set<S>> map;

    public SetMap(Map<K, Set<S>> map) {
        this.map = map;
    }

    private SetMap() {
        this(new HashMap());
    }

    public static final <K, S> SetMap<K, S> createDefault() {
        return new SetMap<K, S>();
    }

    public static final <K, S> SetMap<K, S> createLinked() {
        LinkedHashMap initializer = new LinkedHashMap();
        return new SetMap(initializer);
    }

    public Set<S> getValue(K key) {
        return this.map.get(key);
    }

    public Set<S> add(K key, S value) {
        Set set = this.computeIfAbsent(key, ignoredKey -> new LinkedHashSet());
        set.add(value);
        return set;
    }

    public Set<S> addAll(K key, Set<S> value) {
        Set set = this.computeIfAbsent(key, ignoredKey -> new LinkedHashSet());
        set.addAll(value);
        return set;
    }

    @Override
    public Set<S> put(K key, Set<S> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<S>> mapToAdd) {
        this.map.putAll(mapToAdd);
    }

    @Override
    public Set<Map.Entry<K, Set<S>>> entrySet() {
        return this.map.entrySet();
    }

    public Map<K, Set<S>> getMap() {
        return this.map;
    }

    public void combine(SetMap<K, S> other) {
        other.forEach(this::addAll);
    }
}

