/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.builder;

import com.blackduck.integration.builder.BuilderPropertyKey;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class BuilderProperties {
    private final Map<BuilderPropertyKey, String> values = new HashMap<BuilderPropertyKey, String>();

    public static BuilderProperties createWithStrings(Set<String> keys) {
        Set<BuilderPropertyKey> builderPropertyKeys = keys.stream().map(BuilderPropertyKey::new).collect(Collectors.toSet());
        return new BuilderProperties(builderPropertyKeys);
    }

    public BuilderProperties(Set<BuilderPropertyKey> keys) {
        keys.forEach(key -> this.values.put((BuilderPropertyKey)key, (String)null));
    }

    public String get(BuilderPropertyKey key) {
        return this.values.get(key);
    }

    public void set(BuilderPropertyKey key, String value) {
        if (this.values.containsKey(key)) {
            this.values.put(key, value);
        }
    }

    public void setProperty(String key, String value) {
        BuilderPropertyKey builderPropertyKey = new BuilderPropertyKey(key);
        this.set(builderPropertyKey, value);
    }

    public Set<BuilderPropertyKey> getKeys() {
        return new HashSet<BuilderPropertyKey>(this.values.keySet());
    }

    public Set<String> getPropertyKeys() {
        return this.values.keySet().stream().map(BuilderPropertyKey::getKey).map(key -> key.toLowerCase().replace("_", ".")).collect(Collectors.toSet());
    }

    public Set<String> getEnvironmentVariableKeys() {
        return this.values.keySet().stream().map(BuilderPropertyKey::getKey).collect(Collectors.toSet());
    }

    public Map<BuilderPropertyKey, String> getProperties() {
        return new HashMap<BuilderPropertyKey, String>(this.values);
    }

    public void setProperties(Set<? extends Map.Entry<String, String>> propertyEntries) {
        propertyEntries.stream().map(entry -> {
            BuilderPropertyKey builderPropertyKey = new BuilderPropertyKey((String)entry.getKey());
            return new AbstractMap.SimpleEntry<BuilderPropertyKey, String>(builderPropertyKey, (String)entry.getValue());
        }).forEach(entry -> this.set((BuilderPropertyKey)entry.getKey(), (String)entry.getValue()));
    }
}

