/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.rest.support;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpMethod;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.client.AuthenticatingIntHttpClient;
import com.blackduck.integration.rest.response.DefaultResponse;
import com.blackduck.integration.rest.response.Response;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class AuthenticationSupport {
    public static final List<String> NEED_TO_MANAGE_CONTENT_LENGTH = Arrays.asList(HttpMethod.POST.name(), HttpMethod.PUT.name());
    public static final String AUTHORIZATION_HEADER = "Authorization";

    public Response attemptAuthentication(AuthenticatingIntHttpClient authenticatingIntHttpClient, HttpUrl baseUrl, String authenticationSuffix, Map<String, String> requestHeaders) throws IntegrationException {
        HttpUrl authenticationUrl = baseUrl.appendRelativeUrl(authenticationSuffix);
        RequestBuilder requestBuilder = authenticatingIntHttpClient.createRequestBuilder(HttpMethod.POST, requestHeaders);
        return this.attemptAuthentication(authenticatingIntHttpClient, authenticationUrl, requestBuilder);
    }

    public Response attemptAuthentication(AuthenticatingIntHttpClient authenticatingIntHttpClient, HttpUrl baseUrl, String authenticationSuffix, HttpEntity httpEntity) throws IntegrationException {
        HttpUrl authenticationUrl = baseUrl.appendRelativeUrl(authenticationSuffix);
        RequestBuilder requestBuilder = authenticatingIntHttpClient.createRequestBuilder(HttpMethod.POST);
        requestBuilder.setEntity(httpEntity);
        return this.attemptAuthentication(authenticatingIntHttpClient, authenticationUrl, requestBuilder);
    }

    public Response attemptAuthentication(AuthenticatingIntHttpClient authenticatingIntHttpClient, HttpUrl authenticationUrl, RequestBuilder requestBuilder) throws IntegrationException {
        CloseableHttpResponse closeableHttpResponse;
        requestBuilder.setCharset(StandardCharsets.UTF_8);
        requestBuilder.setUri(authenticationUrl.string());
        if (NEED_TO_MANAGE_CONTENT_LENGTH.contains(requestBuilder.getMethod().toUpperCase()) && null == requestBuilder.getEntity()) {
            requestBuilder.addHeader("Content-Length", "0");
        }
        HttpUriRequest request = requestBuilder.build();
        authenticatingIntHttpClient.logRequestHeaders(request);
        CloseableHttpClient closeableHttpClient = authenticatingIntHttpClient.getClientBuilder().build();
        try {
            closeableHttpResponse = closeableHttpClient.execute(request);
        }
        catch (IOException e) {
            throw new IntegrationException("Could not perform the authorization request: " + e.getMessage(), (Throwable)e);
        }
        authenticatingIntHttpClient.logResponseHeaders((HttpResponse)closeableHttpResponse);
        return new DefaultResponse(request, closeableHttpClient, closeableHttpResponse);
    }

    public void handleErrorResponse(AuthenticatingIntHttpClient authenticatingIntHttpClient, HttpUriRequest request, Response response, String authorizationHeader) {
        if (authenticatingIntHttpClient.isUnauthorized(response) && request.containsHeader(authorizationHeader)) {
            request.removeHeaders(authorizationHeader);
            authenticatingIntHttpClient.removeCommonRequestHeader(authorizationHeader);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> retrieveBearerToken(IntLogger logger, Gson gson, AuthenticatingIntHttpClient authenticatingIntHttpClient, String bearerTokenKey) {
        try (Response response = authenticatingIntHttpClient.attemptAuthentication();){
            String bodyContent;
            if (!response.isStatusCodeSuccess()) return Optional.empty();
            try (InputStream inputStream = response.getContent();){
                bodyContent = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            }
            JsonObject jsonResponse = (JsonObject)gson.fromJson(bodyContent, JsonObject.class);
            String bearerToken = jsonResponse.get(bearerTokenKey).getAsString();
            Optional<String> optional = Optional.of(bearerToken);
            return optional;
        }
        catch (IntegrationException | IOException e) {
            logger.error("Could not retrieve the bearer token", e);
        }
        return Optional.empty();
    }

    public void handleTokenErrorResponse(AuthenticatingIntHttpClient authenticatingIntHttpClient, HttpUriRequest request, Response response) {
        this.handleErrorResponse(authenticatingIntHttpClient, request, response, AUTHORIZATION_HEADER);
    }

    public boolean isTokenAlreadyAuthenticated(HttpUriRequest request) {
        return request.containsHeader(AUTHORIZATION_HEADER);
    }

    public void completeTokenAuthenticationRequest(HttpUriRequest request, Response response, IntLogger logger, Gson gson, AuthenticatingIntHttpClient authenticatingIntHttpClient, String bearerTokenResponseKey) {
        if (response.isStatusCodeSuccess()) {
            Optional<String> bearerToken = this.retrieveBearerToken(logger, gson, authenticatingIntHttpClient, bearerTokenResponseKey);
            this.addBearerToken(logger, request, authenticatingIntHttpClient, bearerToken);
        }
    }

    public void addBearerToken(IntLogger logger, HttpUriRequest request, AuthenticatingIntHttpClient authenticatingIntHttpClient, Optional<String> bearerToken) {
        if (bearerToken.isPresent()) {
            String headerValue = "Bearer " + bearerToken.get();
            this.addAuthenticationHeader(authenticatingIntHttpClient, request, AUTHORIZATION_HEADER, headerValue);
        } else {
            logger.error("No Bearer token found when authenticating.");
        }
    }

    public void addAuthenticationHeader(AuthenticatingIntHttpClient authenticatingIntHttpClient, HttpUriRequest request, String headerName, String headerValue) {
        authenticatingIntHttpClient.addCommonRequestHeader(headerName, headerValue);
        request.setHeader(headerName, headerValue);
    }
}

