/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.rest.proxy;

import com.blackduck.integration.builder.Buildable;
import com.blackduck.integration.rest.credentials.Credentials;
import com.blackduck.integration.rest.proxy.ProxyInfoBuilder;
import com.blackduck.integration.util.Stringable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;

public class ProxyInfo
extends Stringable
implements Buildable {
    public static final ProxyInfo NO_PROXY_INFO = new ProxyInfo();
    private final String host;
    private final int port;
    private final Credentials proxyCredentials;
    private final String ntlmDomain;
    private final String ntlmWorkstation;
    private final boolean blank;

    public static ProxyInfoBuilder newBuilder() {
        return new ProxyInfoBuilder();
    }

    ProxyInfo(String host, int port, Credentials proxyCredentials, String ntlmDomain, String ntlmWorkstation) {
        this.host = host;
        this.port = port;
        this.proxyCredentials = proxyCredentials;
        this.ntlmDomain = ntlmDomain;
        this.ntlmWorkstation = ntlmWorkstation;
        this.blank = false;
    }

    ProxyInfo() {
        this.host = null;
        this.port = 0;
        this.proxyCredentials = null;
        this.ntlmDomain = null;
        this.ntlmWorkstation = null;
        this.blank = true;
    }

    public boolean isBlank() {
        return this.blank;
    }

    public boolean shouldUseProxy() {
        return !this.isBlank();
    }

    public Optional<URLConnection> openConnection(URL url) throws IOException {
        if (this.getProxy().isPresent()) {
            return Optional.of(url.openConnection(this.getProxy().get()));
        }
        return Optional.empty();
    }

    public Optional<Proxy> getProxy() {
        if (this.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port)));
    }

    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    public int getPort() {
        return this.port;
    }

    public Optional<String> getUsername() {
        if (this.getProxyCredentials().isPresent()) {
            return this.getProxyCredentials().get().getUsername();
        }
        return Optional.empty();
    }

    public Optional<String> getPassword() {
        if (this.getProxyCredentials().isPresent()) {
            return this.getProxyCredentials().get().getPassword();
        }
        return Optional.empty();
    }

    public Optional<String> getMaskedPassword() {
        if (this.getProxyCredentials().isPresent()) {
            return Optional.of(this.getProxyCredentials().get().getMaskedPassword());
        }
        return Optional.empty();
    }

    public Optional<String> getNtlmDomain() {
        return Optional.ofNullable(this.ntlmDomain);
    }

    public Optional<String> getNtlmWorkstation() {
        return Optional.ofNullable(this.ntlmWorkstation);
    }

    public boolean hasAuthenticatedProxySettings() {
        return null != this.proxyCredentials && !this.proxyCredentials.isBlank();
    }

    public Optional<Credentials> getProxyCredentials() {
        return Optional.ofNullable(this.proxyCredentials);
    }
}

