/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio.model.externalid;

import com.blackduck.integration.bdio.model.Forge;
import com.blackduck.integration.bdio.model.externalid.ExternalId;

public class ExternalIdFactory {
    public ExternalId createPathExternalId(Forge forge, String path) {
        ExternalId externalId = new ExternalId(forge);
        externalId.setPath(path);
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createModuleNamesExternalId(Forge forge, String ... moduleNames) {
        ExternalId externalId = new ExternalId(forge);
        externalId.setModuleNames(moduleNames);
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createNameVersionExternalId(Forge forge, String name, String version) {
        ExternalId externalId = new ExternalId(forge);
        externalId.setName(name);
        externalId.setVersion(version);
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createNameVersionExternalId(Forge forge, String name) {
        return this.createNameVersionExternalId(forge, name, null);
    }

    public ExternalId createYoctoExternalId(String layer, String name, String version) {
        ExternalId externalId = this.createNameVersionExternalId(Forge.YOCTO, name, version);
        externalId.setLayer(layer);
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createYoctoExternalId(String layer, String name) {
        return this.createYoctoExternalId(layer, name, null);
    }

    public ExternalId createEclipseExternalId(String name, String version) {
        ExternalId externalId = this.createNameVersionExternalId(Forge.ECLIPSE, name, version);
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createMavenExternalId(String group, String name, String version) {
        ExternalId externalId = this.createNameVersionExternalId(Forge.MAVEN, name, version);
        externalId.setGroup(group);
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createMavenExternalId(String group, String name) {
        return this.createMavenExternalId(group, name, null);
    }

    public ExternalId createArchitectureExternalId(Forge forge, String name, String version, String architecture) {
        ExternalId externalId = this.createNameVersionExternalId(forge, name, version);
        externalId.setArchitecture(architecture);
        this.checkForValidity(externalId);
        return externalId;
    }

    public ExternalId createArchitectureExternalId(Forge forge, String name, String architecture) {
        return this.createArchitectureExternalId(forge, name, null, architecture);
    }

    private void checkForValidity(ExternalId externalId) {
        externalId.createBdioId();
    }
}

