/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio.model.dependency;

import com.blackduck.integration.bdio.model.Forge;
import com.blackduck.integration.bdio.model.dependency.Dependency;
import com.blackduck.integration.bdio.model.externalid.ExternalId;
import com.blackduck.integration.bdio.model.externalid.ExternalIdFactory;

public class DependencyFactory {
    private final ExternalIdFactory externalIdFactory;

    public DependencyFactory() {
        this(ExternalId.FACTORY);
    }

    public DependencyFactory(ExternalIdFactory externalIdFactory) {
        this.externalIdFactory = externalIdFactory;
    }

    public Dependency createPathDependency(Forge forge, String path) {
        return new Dependency(this.externalIdFactory.createPathExternalId(forge, path), null);
    }

    public Dependency createModuleNamesDependency(Forge forge, String ... moduleNames) {
        return new Dependency(this.externalIdFactory.createModuleNamesExternalId(forge, moduleNames), null);
    }

    public Dependency createNameVersionDependency(String scope, Forge forge, String name, String version) {
        return new Dependency(name, version, this.externalIdFactory.createNameVersionExternalId(forge, name, version), scope);
    }

    public Dependency createNameVersionDependency(Forge forge, String name, String version) {
        return this.createNameVersionDependency(null, forge, name, version);
    }

    public Dependency createNameVersionDependency(Forge forge, String name) {
        return this.createNameVersionDependency(null, forge, name, null);
    }

    public Dependency createYoctoDependency(String scope, String layer, String name, String version) {
        return new Dependency(this.externalIdFactory.createYoctoExternalId(layer, name, version), scope);
    }

    public Dependency createYoctoDependency(String layer, String name, String version) {
        return this.createYoctoDependency(null, layer, name, version);
    }

    public Dependency createYoctoDependency(String layer, String name) {
        return this.createYoctoDependency(null, layer, name, null);
    }

    public Dependency createMavenDependency(String scope, String group, String name, String version) {
        return new Dependency(this.externalIdFactory.createMavenExternalId(group, name, version), scope);
    }

    public Dependency createMavenDependency(String group, String name, String version) {
        return this.createMavenDependency(null, group, name, version);
    }

    public Dependency createMavenDependency(String group, String name) {
        return this.createMavenDependency(null, group, name, null);
    }

    public Dependency createArchitectureDependency(Forge forge, String name, String version, String architecture) {
        return new Dependency(this.externalIdFactory.createArchitectureExternalId(forge, name, version, architecture), null);
    }

    public Dependency createArchitectureDependency(Forge forge, String name, String architecture) {
        return this.createArchitectureDependency(forge, name, null, architecture);
    }
}

