/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio.model.dependency;

import com.blackduck.integration.bdio.model.dependency.DependencyFactory;
import com.blackduck.integration.bdio.model.externalid.ExternalId;
import com.blackduck.integration.util.Stringable;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Dependency
extends Stringable {
    public static final DependencyFactory FACTORY = new DependencyFactory();
    private String name;
    private String version;
    private ExternalId externalId;
    private String scope;

    public Dependency(String name, String version, ExternalId externalId, String scope) {
        this.name = name;
        this.version = version;
        this.externalId = externalId;
        this.scope = scope;
    }

    public Dependency(String name, ExternalId externalId, String scope) {
        this(name, externalId.getVersion(), externalId, scope);
    }

    public Dependency(ExternalId externalId, String scope) {
        this(externalId.getName(), externalId.getVersion(), externalId, scope);
    }

    @Deprecated
    public Dependency(String name, String version, ExternalId externalId) {
        this(name, version, externalId, null);
    }

    @Deprecated
    public Dependency(String name, ExternalId externalId) {
        this(name, externalId.getVersion(), externalId, null);
    }

    @Deprecated
    public Dependency(ExternalId externalId) {
        this(externalId.getName(), externalId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ExternalId getExternalId() {
        return this.externalId;
    }

    public void setExternalId(ExternalId externalId) {
        this.externalId = externalId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.version, this.externalId, this.scope});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)((Object)obj);
        return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals((Object)this.externalId, (Object)that.externalId) && Objects.equals(this.scope, that.scope);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("name", (Object)this.name).append("version", (Object)this.version).append("externalId", (Object)this.externalId).append("scope", (Object)this.scope).build();
    }
}

