/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio.model;

import com.blackduck.integration.bdio.model.BdioIdAdapter;
import com.blackduck.integration.bdio.model.BdioIdEscaper;
import com.google.gson.annotations.JsonAdapter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonAdapter(value=BdioIdAdapter.class)
public class BdioId {
    public static final String BDIO_ID_SEPARATOR = "/";
    private static final BdioIdEscaper bdioIdEscaper = new BdioIdEscaper();
    private final String id;

    public static BdioId createFromPieces(List<String> pieces) {
        return new BdioId("http:" + StringUtils.join(bdioIdEscaper.escapePiecesForUri(pieces), (String)BDIO_ID_SEPARATOR));
    }

    public static BdioId createFromPieces(String ... pieces) {
        return BdioId.createFromPieces(Arrays.asList(pieces));
    }

    public static BdioId createFromUUID(String uuid) {
        return new BdioId(String.format("uuid:%s", uuid));
    }

    public BdioId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BdioId bdioId = (BdioId)o;
        return Objects.equals(this.id, bdioId.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }
}

