/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio.graph.builder;

import com.blackduck.integration.bdio.graph.builder.LazyIdSource;
import com.blackduck.integration.util.NameVersion;
import com.blackduck.integration.util.Stringable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class LazyId
extends Stringable {
    private final List<String> pieces = new LinkedList<String>();
    private String toStringResult;

    public static LazyId fromName(String name) {
        return new LazyId(LazyIdSource.NAME, Arrays.asList(name));
    }

    public static LazyId fromNameAndVersion(String name, String version) {
        return new LazyId(LazyIdSource.NAME_VERSION, Arrays.asList(name, version));
    }

    public static LazyId fromNameVersion(NameVersion nameVersion) {
        return new LazyId(LazyIdSource.NAME_VERSION, Arrays.asList(nameVersion.getName(), nameVersion.getVersion()));
    }

    public static LazyId fromString(String s) {
        return new LazyId(LazyIdSource.STRING, Arrays.asList(s));
    }

    public LazyId(LazyIdSource source, List<String> pieces) {
        this.pieces.add(source.name());
        this.pieces.addAll(pieces);
    }

    public int hashCode() {
        return this.pieces.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LazyId)) {
            return false;
        }
        LazyId other = (LazyId)((Object)obj);
        return this.pieces.equals(other.pieces);
    }

    public String toString() {
        if (this.toStringResult == null) {
            this.toStringResult = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("pieces", this.pieces).build();
        }
        return this.toStringResult;
    }
}

