/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio.graph.builder;

import com.blackduck.integration.bdio.graph.BasicDependencyGraph;
import com.blackduck.integration.bdio.graph.builder.LazyBuilderMissingExternalIdHandler;
import com.blackduck.integration.bdio.graph.builder.LazyId;
import com.blackduck.integration.bdio.graph.builder.MissingExternalIdException;
import com.blackduck.integration.bdio.model.dependency.Dependency;
import com.blackduck.integration.bdio.model.externalid.ExternalId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LazyExternalIdDependencyGraphBuilder {
    private final Set<LazyId> rootLazyIds = new HashSet<LazyId>();
    private final Map<LazyId, LazyDependencyInfo> dependencyInfo = new HashMap<LazyId, LazyDependencyInfo>();

    private LazyDependencyInfo infoForId(LazyId id) {
        LazyDependencyInfo info = this.dependencyInfo.get((Object)id);
        if (info.getAliasId() != null) {
            info = this.dependencyInfo.get((Object)info.getAliasId());
        }
        return info;
    }

    public BasicDependencyGraph build() throws MissingExternalIdException {
        return this.build((lazyId, lazyDependencyInfo) -> {
            if (lazyDependencyInfo != null && lazyDependencyInfo.aliasId != null) {
                throw new MissingExternalIdException(lazyDependencyInfo.aliasId);
            }
            throw new MissingExternalIdException(lazyId);
        });
    }

    public BasicDependencyGraph build(LazyBuilderMissingExternalIdHandler lazyBuilderHandler) throws MissingExternalIdException {
        LazyDependencyInfo lazyDependencyInfo;
        BasicDependencyGraph mutableDependencyGraph = new BasicDependencyGraph();
        for (LazyId lazyId : this.dependencyInfo.keySet()) {
            lazyDependencyInfo = this.infoForId(lazyId);
            if (lazyDependencyInfo.getExternalId() != null) continue;
            ExternalId handledExternalId = lazyBuilderHandler.handleMissingExternalId(lazyId, lazyDependencyInfo);
            if (handledExternalId == null || lazyId == null) {
                throw new MissingExternalIdException(lazyId);
            }
            lazyDependencyInfo.setExternalId(handledExternalId);
        }
        for (LazyId lazyId : this.dependencyInfo.keySet()) {
            lazyDependencyInfo = this.infoForId(lazyId);
            Dependency dependency = new Dependency(lazyDependencyInfo.getName(), lazyDependencyInfo.getVersion(), lazyDependencyInfo.getExternalId(), null);
            for (LazyId child : lazyDependencyInfo.getChildren()) {
                LazyDependencyInfo childInfo = this.infoForId(child);
                mutableDependencyGraph.addParentWithChild(dependency, new Dependency(childInfo.getName(), childInfo.getVersion(), childInfo.getExternalId(), null));
            }
            if (!this.rootLazyIds.contains((Object)lazyId) && !this.rootLazyIds.contains((Object)lazyDependencyInfo.getAliasId())) continue;
            mutableDependencyGraph.addDirectDependency(dependency);
        }
        return mutableDependencyGraph;
    }

    private void ensureDependencyInfoExists(LazyId lazyId) {
        this.dependencyInfo.computeIfAbsent(lazyId, key -> new LazyDependencyInfo());
    }

    public void setDependencyAsAlias(LazyId realLazyId, LazyId fakeLazyId) {
        this.ensureDependencyInfoExists(realLazyId);
        this.ensureDependencyInfoExists(fakeLazyId);
        LazyDependencyInfo info = this.dependencyInfo.get((Object)fakeLazyId);
        info.setAliasId(realLazyId);
    }

    public void setDependencyInfo(LazyId id, String name, String version, ExternalId externalId) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get((Object)id);
        info.setName(name);
        info.setVersion(version);
        info.setExternalId(externalId);
    }

    public void setDependencyName(LazyId id, String name) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get((Object)id);
        info.setName(name);
    }

    public void setDependencyVersion(LazyId id, String version) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get((Object)id);
        info.setVersion(version);
    }

    public void setDependencyExternalId(LazyId id, ExternalId externalId) {
        this.ensureDependencyInfoExists(id);
        LazyDependencyInfo info = this.dependencyInfo.get((Object)id);
        info.setExternalId(externalId);
    }

    public void addParentWithChild(LazyId parent, LazyId child) {
        this.ensureDependencyInfoExists(child);
        this.ensureDependencyInfoExists(parent);
        this.dependencyInfo.get((Object)parent).getChildren().add(child);
    }

    public void addParentWithChildren(LazyId parent, List<LazyId> children) {
        for (LazyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addParentWithChildren(LazyId parent, Set<LazyId> children) {
        for (LazyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addParentWithChildren(LazyId parent, LazyId ... children) {
        for (LazyId child : children) {
            this.addParentWithChild(parent, child);
        }
    }

    public void addChildWithParent(LazyId child, LazyId parent) {
        this.addParentWithChild(parent, child);
    }

    public void addChildWithParents(LazyId child, List<LazyId> parents) {
        for (LazyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildWithParents(LazyId child, Set<LazyId> parents) {
        for (LazyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildWithParents(LazyId child, LazyId ... parents) {
        for (LazyId parent : parents) {
            this.addChildWithParent(child, parent);
        }
    }

    public void addChildToRoot(LazyId child) {
        this.ensureDependencyInfoExists(child);
        this.rootLazyIds.add(child);
    }

    public void addChildrenToRoot(List<LazyId> children) {
        for (LazyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public void addChildrenToRoot(Set<LazyId> children) {
        for (LazyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public void addChildrenToRoot(LazyId ... children) {
        for (LazyId child : children) {
            this.addChildToRoot(child);
        }
    }

    public static class LazyDependencyInfo {
        private Set<LazyId> children = new HashSet<LazyId>();
        private LazyId aliasId;
        private ExternalId externalId;
        private String name;
        private String version;

        public Set<LazyId> getChildren() {
            return this.children;
        }

        public void setChildren(Set<LazyId> children) {
            this.children = children;
        }

        public LazyId getAliasId() {
            return this.aliasId;
        }

        public void setAliasId(LazyId aliasId) {
            this.aliasId = aliasId;
        }

        public ExternalId getExternalId() {
            return this.externalId;
        }

        public void setExternalId(ExternalId externalId) {
            this.externalId = externalId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

