/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio.graph;

import com.blackduck.integration.bdio.graph.DependencyGraphUtil;
import com.blackduck.integration.bdio.model.dependency.Dependency;
import com.blackduck.integration.bdio.model.externalid.ExternalId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class DependencyGraph {
    protected final Map<ExternalId, Dependency> dependencies = new HashMap<ExternalId, Dependency>();
    protected final Map<ExternalId, Set<ExternalId>> relationships = new HashMap<ExternalId, Set<ExternalId>>();

    @Deprecated
    public void addChildToRoot(Dependency child) {
        this.addDirectDependency(child);
    }

    public abstract void addDirectDependency(Dependency var1);

    public abstract Set<Dependency> getDirectDependencies();

    public abstract Set<Dependency> getRootDependencies();

    public void copyGraphToRoot(DependencyGraph sourceGraph) {
        DependencyGraphUtil.copyRootDependencies(this, sourceGraph);
    }

    public boolean hasDependency(ExternalId dependency) {
        return this.dependencies.containsKey((Object)dependency);
    }

    public boolean hasDependency(Dependency dependency) {
        return this.dependencies.containsKey((Object)dependency.getExternalId());
    }

    @Nullable
    public Dependency getDependency(ExternalId dependency) {
        return this.dependencies.getOrDefault((Object)dependency, null);
    }

    public Set<Dependency> getChildrenForParent(ExternalId parent) {
        return this.getChildrenExternalIdsForParent(parent).stream().map(this.dependencies::get).collect(Collectors.toSet());
    }

    public Set<Dependency> getParentsForChild(ExternalId child) {
        return this.getParentExternalIdsForChild(child).stream().map(this.dependencies::get).collect(Collectors.toSet());
    }

    public Set<ExternalId> getChildrenExternalIdsForParent(ExternalId parent) {
        return this.relationships.getOrDefault((Object)parent, new HashSet());
    }

    public Set<Dependency> getChildrenForParent(Dependency parent) {
        return this.getChildrenForParent(parent.getExternalId());
    }

    public Set<Dependency> getParentsForChild(Dependency child) {
        return this.getParentsForChild(child.getExternalId());
    }

    public Set<ExternalId> getChildrenExternalIdsForParent(Dependency parent) {
        return this.getChildrenExternalIdsForParent(parent.getExternalId());
    }

    public Set<ExternalId> getParentExternalIdsForChild(Dependency child) {
        return this.getParentExternalIdsForChild(child.getExternalId());
    }

    public Set<ExternalId> getParentExternalIdsForChild(ExternalId child) {
        return this.relationships.entrySet().stream().filter(externalIdSetEntry -> ((Set)externalIdSetEntry.getValue()).stream().anyMatch(child::equals)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void addParentWithChild(Dependency parent, Dependency child) {
        this.ensureDependencyAndRelationshipExists(parent);
        this.ensureDependencyExists(child);
        this.addRelationship(parent, child);
    }

    public void addChildWithParent(Dependency child, Dependency parent) {
        this.addParentWithChild(parent, child);
    }

    public void addParentWithChildren(Dependency parent, List<Dependency> children) {
        this.ensureDependencyAndRelationshipExists(parent);
        for (Dependency child : children) {
            this.ensureDependencyExists(child);
            this.addRelationship(parent, child);
        }
    }

    public void addChildWithParents(Dependency child, List<Dependency> parents) {
        this.ensureDependencyExists(child);
        for (Dependency parent : parents) {
            this.ensureDependencyAndRelationshipExists(parent);
            this.addRelationship(parent, child);
        }
    }

    public void addParentWithChildren(Dependency parent, Set<Dependency> children) {
        this.ensureDependencyAndRelationshipExists(parent);
        for (Dependency child : children) {
            this.ensureDependencyExists(child);
            this.addRelationship(parent, child);
        }
    }

    public void addChildWithParents(Dependency child, Set<Dependency> parents) {
        this.ensureDependencyExists(child);
        for (Dependency parent : parents) {
            this.ensureDependencyAndRelationshipExists(parent);
            this.addRelationship(parent, child);
        }
    }

    public void addParentWithChildren(Dependency parent, Dependency ... children) {
        this.addParentWithChildren(parent, Arrays.asList(children));
    }

    public void addChildWithParents(Dependency child, Dependency ... parents) {
        this.addChildWithParents(child, Arrays.asList(parents));
    }

    public void addChildrenToRoot(List<Dependency> children) {
        children.forEach(this::addDirectDependency);
    }

    public void addChildrenToRoot(Set<Dependency> children) {
        children.forEach(this::addDirectDependency);
    }

    public void addChildrenToRoot(Dependency ... children) {
        Arrays.stream(children).forEach(this::addDirectDependency);
    }

    protected void ensureDependencyExists(Dependency dependency) {
        this.dependencies.putIfAbsent(dependency.getExternalId(), dependency);
    }

    protected void ensureDependencyAndRelationshipExists(Dependency dependency) {
        this.ensureDependencyExists(dependency);
        this.relationships.putIfAbsent(dependency.getExternalId(), new HashSet());
    }

    protected void addRelationship(Dependency parent, Dependency child) {
        this.relationships.get((Object)parent.getExternalId()).add(child.getExternalId());
    }
}

