/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.bdio;

import com.blackduck.integration.bdio.graph.ProjectDependencyGraph;
import com.blackduck.integration.bdio.model.BdioComponent;
import com.blackduck.integration.bdio.model.BdioId;
import com.blackduck.integration.bdio.model.BdioProject;
import com.blackduck.integration.bdio.model.BdioRelationship;
import com.blackduck.integration.bdio.model.Forge;
import com.blackduck.integration.bdio.model.dependency.Dependency;
import com.blackduck.integration.bdio.model.dependency.ProjectDependency;
import com.blackduck.integration.bdio.model.externalid.ExternalId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BdioTransformer {
    private final Map<String, Forge> forgeMap;

    public BdioTransformer() {
        this.forgeMap = Forge.getKnownForges();
    }

    public BdioTransformer(Map<String, Forge> forgeMap) {
        this.forgeMap = forgeMap;
    }

    public ProjectDependencyGraph transformToDependencyGraph(ProjectDependency projectDependency, BdioProject project, List<BdioComponent> components) {
        ProjectDependencyGraph dependencyGraph = new ProjectDependencyGraph(projectDependency);
        HashMap<BdioId, Dependency> bdioIdToDependencyMap = new HashMap<BdioId, Dependency>();
        for (BdioComponent component : components) {
            ExternalId externalId = component.bdioExternalIdentifier.externalIdMetaData;
            if (externalId == null) {
                Forge forge = this.forgeMap.get(component.bdioExternalIdentifier.forge);
                externalId = ExternalId.createFromExternalId(forge, component.bdioExternalIdentifier.externalId, component.name, component.version);
            }
            Dependency dependency = new Dependency(component.name, component.version, externalId, null);
            bdioIdToDependencyMap.put(component.id, dependency);
        }
        for (BdioRelationship relation : project.relationships) {
            dependencyGraph.addChildrenToRoot((Dependency)((Object)bdioIdToDependencyMap.get(relation.related)));
        }
        for (BdioComponent component : components) {
            Dependency dependency = (Dependency)((Object)bdioIdToDependencyMap.get(component.id));
            for (BdioRelationship relation : component.relationships) {
                dependencyGraph.addParentWithChild(dependency, (Dependency)((Object)bdioIdToDependencyMap.get(relation.related)));
            }
        }
        return dependencyGraph;
    }
}

