/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.phonehome.request;

import com.blackduck.integration.phonehome.UniquePhoneHomeProduct;
import com.blackduck.integration.phonehome.request.PhoneHomeRequestBody;
import com.blackduck.integration.util.NameVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PhoneHomeRequestBodyBuilder {
    private final String customerId;
    private final String hostName;
    private final NameVersion artifactInfo;
    private final UniquePhoneHomeProduct product;
    private final String productVersion;
    private final List<String> artifactModules = new ArrayList<String>();
    private final Map<String, String> metaData = new HashMap<String, String>();

    public static PhoneHomeRequestBodyBuilder createForBlackDuck(String integrationRepoName, String registrationId, String blackDuckServerUrl, @Nullable String integrationVersion, @Nullable String blackDuckVersion) {
        return PhoneHomeRequestBodyBuilder.createForProduct(UniquePhoneHomeProduct.BLACK_DUCK, integrationRepoName, registrationId, blackDuckServerUrl, integrationVersion, blackDuckVersion);
    }

    public static PhoneHomeRequestBodyBuilder createForCoverity(String integrationRepoName, String customerName, String cimServerUrl, @Nullable String integrationVersion, @Nullable String cimVersion) {
        return PhoneHomeRequestBodyBuilder.createForProduct(UniquePhoneHomeProduct.COVERITY, integrationRepoName, customerName, cimServerUrl, integrationVersion, cimVersion);
    }

    public static PhoneHomeRequestBodyBuilder createForPolaris(String integrationRepoName, String organizationName, String polarisServerUrl, @Nullable String integrationVersion, @Nullable String polarisVersion) {
        return PhoneHomeRequestBodyBuilder.createForProduct(UniquePhoneHomeProduct.POLARIS, integrationRepoName, organizationName, polarisServerUrl, integrationVersion, polarisVersion);
    }

    public static PhoneHomeRequestBodyBuilder createForProduct(UniquePhoneHomeProduct product, String artifactId, String customerId, String hostName, @Nullable String artifactVersion, @Nullable String productVersion) {
        artifactVersion = (String)StringUtils.defaultIfEmpty((CharSequence)artifactVersion, (CharSequence)"<unknown>");
        productVersion = (String)StringUtils.defaultIfEmpty((CharSequence)productVersion, (CharSequence)"<unknown>");
        NameVersion artifactInfo = new NameVersion(artifactId, artifactVersion);
        return new PhoneHomeRequestBodyBuilder(customerId, hostName, artifactInfo, product, productVersion);
    }

    public PhoneHomeRequestBodyBuilder(String customerId, String hostName, NameVersion artifactInfo, UniquePhoneHomeProduct product, String productVersion) {
        if (null == product || null == artifactInfo || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{customerId, hostName, artifactInfo.getName(), artifactInfo.getVersion(), product.getName(), productVersion})) {
            throw new IllegalArgumentException("The fields: customerId, hostName, artifactInfo, and product (with a non-blank name), and productVersion are all required.");
        }
        assert (customerId != null);
        this.customerId = customerId;
        this.hostName = hostName;
        this.artifactInfo = artifactInfo;
        this.product = product;
        this.productVersion = productVersion;
    }

    public PhoneHomeRequestBody build() {
        return new PhoneHomeRequestBody(this);
    }

    public boolean addToMetaData(String key, String value) {
        if (this.charactersInMetaDataMap(key, value) < 1536) {
            this.metaData.put(key, value);
            return true;
        }
        return false;
    }

    public boolean addAllToMetaData(Map<String, String> metadataMap) {
        return metadataMap.entrySet().stream().allMatch(entry -> this.addToMetaData((String)entry.getKey(), (String)entry.getValue()));
    }

    public void addArtifactModule(String artifactModule) {
        this.artifactModules.add(artifactModule);
    }

    public void addArtifactModules(String ... artifactModules) {
        this.artifactModules.addAll(Arrays.asList(artifactModules));
    }

    private int charactersInMetaDataMap(String key, String value) {
        int mapEntryWrappingCharacters = 6;
        String mapAsString = this.getMetaData().toString();
        return 6 + mapAsString.length() + key.length() + value.length();
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public NameVersion getArtifactInfo() {
        return this.artifactInfo;
    }

    public UniquePhoneHomeProduct getProduct() {
        return this.product;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public List<String> getArtifactModules() {
        return this.artifactModules;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }
}

